/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import java.nio.DoubleBuffer;

public class DistanceConstraintSettings
extends TwoBodyConstraintSettings {
    public DistanceConstraintSettings() {
        long settingsVa = DistanceConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Distance);
    }

    public DistanceConstraintSettings(DistanceConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = DistanceConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Distance);
    }

    DistanceConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Distance);
    }

    public SpringSettings getLimitsSpringSettings() {
        long constraintSettingsVa = this.va();
        long springSettingsVa = DistanceConstraintSettings.getLimitsSpringSettings(constraintSettingsVa);
        SpringSettings result = new SpringSettings(this, springSettingsVa);
        return result;
    }

    public float getMaxDistance() {
        long settingsVa = this.va();
        float result = DistanceConstraintSettings.getMaxDistance(settingsVa);
        return result;
    }

    public float getMinDistance() {
        long settingsVa = this.va();
        float result = DistanceConstraintSettings.getMinDistance(settingsVa);
        return result;
    }

    public RVec3 getPoint1() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        DistanceConstraintSettings.getPoint1(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPoint2() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        DistanceConstraintSettings.getPoint2(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = DistanceConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public void setMaxDistance(float distance) {
        long settingsVa = this.va();
        DistanceConstraintSettings.setMaxDistance(settingsVa, distance);
    }

    public void setMinDistance(float distance) {
        long settingsVa = this.va();
        DistanceConstraintSettings.setMinDistance(settingsVa, distance);
    }

    public void setPoint1(double xx, double yy, double zz) {
        long settingsVa = this.va();
        DistanceConstraintSettings.setPoint1(settingsVa, xx, yy, zz);
    }

    public RVec3Arg setPoint1(RVec3Arg location) {
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        this.setPoint1(xx, yy, zz);
        return location;
    }

    public void setPoint2(double xx, double yy, double zz) {
        long settingsVa = this.va();
        DistanceConstraintSettings.setPoint2(settingsVa, xx, yy, zz);
    }

    public RVec3Arg setPoint2(RVec3Arg location) {
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        this.setPoint2(xx, yy, zz);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        DistanceConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long getLimitsSpringSettings(long var0);

    private static native float getMaxDistance(long var0);

    private static native float getMinDistance(long var0);

    private static native void getPoint1(long var0, DoubleBuffer var2);

    private static native void getPoint2(long var0, DoubleBuffer var2);

    private static native int getSpace(long var0);

    private static native void setMaxDistance(long var0, float var2);

    private static native void setMinDistance(long var0, float var2);

    private static native void setPoint1(long var0, double var2, double var4, double var6);

    private static native void setPoint2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);
}

