/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.enumerate.EMotorState;

public class HingeConstraint
extends TwoBodyConstraint {
    HingeConstraint(long constraintVa) {
        this.setVirtualAddressAsCoOwner(constraintVa);
    }

    public float getCurrentAngle() {
        long constraintVa = this.va();
        float result = HingeConstraint.getCurrentAngle(constraintVa);
        return result;
    }

    public float getLimitsMax() {
        long constraintVa = this.va();
        float result = HingeConstraint.getLimitsMax(constraintVa);
        return result;
    }

    public float getLimitsMin() {
        long constraintVa = this.va();
        float result = HingeConstraint.getLimitsMin(constraintVa);
        return result;
    }

    public SpringSettings getLimitsSpringSettings() {
        long constraintVa = this.va();
        long settingsVa = HingeConstraint.getLimitsSpringSettings(constraintVa);
        SpringSettings result = new SpringSettings(this, settingsVa);
        return result;
    }

    public float getMaxFrictionTorque() {
        long constraintVa = this.va();
        float result = HingeConstraint.getMaxFrictionTorque(constraintVa);
        return result;
    }

    public MotorSettings getMotorSettings() {
        long constraintVa = this.va();
        long settingsVa = HingeConstraint.getMotorSettings(constraintVa);
        MotorSettings result = new MotorSettings(this, settingsVa);
        return result;
    }

    public EMotorState getMotorState() {
        long constraintVa = this.va();
        int ordinal = HingeConstraint.getMotorState(constraintVa);
        EMotorState result = EMotorState.values()[ordinal];
        return result;
    }

    public float getTargetAngle() {
        long constraintVa = this.va();
        float result = HingeConstraint.getTargetAngle(constraintVa);
        return result;
    }

    public float getTargetAngularVelocity() {
        long constraintVa = this.va();
        float result = HingeConstraint.getTargetAngularVelocity(constraintVa);
        return result;
    }

    public boolean hasLimits() {
        long constraintVa = this.va();
        boolean result = HingeConstraint.hasLimits(constraintVa);
        return result;
    }

    public void setLimits(float min, float max) {
        long constraintVa = this.va();
        HingeConstraint.setLimits(constraintVa, min, max);
    }

    public void setMaxFrictionTorque(float torque) {
        long constraintVa = this.va();
        HingeConstraint.setMaxFrictionTorque(constraintVa, torque);
    }

    public void setMotorState(EMotorState state) {
        long constraintVa = this.va();
        int ordinal = state.ordinal();
        HingeConstraint.setMotorState(constraintVa, ordinal);
    }

    public void setTargetAngle(float angle) {
        long constraintVa = this.va();
        HingeConstraint.setTargetAngle(constraintVa, angle);
    }

    public void setTargetAngularVelocity(float omega) {
        long constraintVa = this.va();
        HingeConstraint.setTargetAngularVelocity(constraintVa, omega);
    }

    private static native float getCurrentAngle(long var0);

    private static native float getLimitsMax(long var0);

    private static native float getLimitsMin(long var0);

    private static native long getLimitsSpringSettings(long var0);

    private static native float getMaxFrictionTorque(long var0);

    private static native long getMotorSettings(long var0);

    private static native int getMotorState(long var0);

    private static native float getTargetAngle(long var0);

    private static native float getTargetAngularVelocity(long var0);

    private static native boolean hasLimits(long var0);

    private static native void setLimits(long var0, float var2, float var3);

    private static native void setMaxFrictionTorque(long var0, float var2);

    private static native void setMotorState(long var0, int var2);

    private static native void setTargetAngle(long var0, float var2);

    private static native void setTargetAngularVelocity(long var0, float var2);
}

