/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;

public class PointConstraintSettings
extends TwoBodyConstraintSettings {
    public PointConstraintSettings() {
        long settingsVa = PointConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Point);
    }

    PointConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Point);
    }

    public PointConstraintSettings(PointConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = PointConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Point);
    }

    public RVec3 getPoint1() {
        long settingsVa = this.va();
        double x = PointConstraintSettings.getPoint1X(settingsVa);
        double y = PointConstraintSettings.getPoint1Y(settingsVa);
        double z = PointConstraintSettings.getPoint1Z(settingsVa);
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public RVec3 getPoint2() {
        long settingsVa = this.va();
        double x = PointConstraintSettings.getPoint2X(settingsVa);
        double y = PointConstraintSettings.getPoint2Y(settingsVa);
        double z = PointConstraintSettings.getPoint2Z(settingsVa);
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = PointConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public void setPoint1(double xx, double yy, double zz) {
        long settingsVa = this.va();
        PointConstraintSettings.setPoint1(settingsVa, xx, yy, zz);
    }

    public RVec3Arg setPoint1(RVec3Arg location) {
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        this.setPoint1(x, y, z);
        return location;
    }

    public void setPoint2(double xx, double yy, double zz) {
        long settingsVa = this.va();
        PointConstraintSettings.setPoint2(settingsVa, xx, yy, zz);
    }

    public RVec3Arg setPoint2(RVec3Arg location) {
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        this.setPoint2(x, y, z);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        PointConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native double getPoint1X(long var0);

    private static native double getPoint1Y(long var0);

    private static native double getPoint1Z(long var0);

    private static native double getPoint2X(long var0);

    private static native double getPoint2Y(long var0);

    private static native double getPoint2Z(long var0);

    private static native int getSpace(long var0);

    private static native void setPoint1(long var0, double var2, double var4, double var6);

    private static native void setPoint2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);
}

