/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class RRayCast
extends JoltPhysicsObject {
    public RRayCast(RVec3Arg startLocation, Vec3Arg offset) {
        double xx = startLocation.xx();
        double yy = startLocation.yy();
        double zz = startLocation.zz();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        long raycastVa = RRayCast.createRRayCast(xx, yy, zz, dx, dy, dz);
        this.setVirtualAddress(raycastVa, () -> RRayCast.free(raycastVa));
    }

    public Vec3 getDirection() {
        long raycastVa = this.va();
        float x = RRayCast.getDirectionX(raycastVa);
        float y = RRayCast.getDirectionY(raycastVa);
        float z = RRayCast.getDirectionZ(raycastVa);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public RVec3 getOrigin() {
        long raycastVa = this.va();
        double x = RRayCast.getOriginX(raycastVa);
        double y = RRayCast.getOriginY(raycastVa);
        double z = RRayCast.getOriginZ(raycastVa);
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public RVec3 getPointOnRay(float fraction) {
        long raycastVa = this.va();
        double xx = RRayCast.getPointOnRayX(raycastVa, fraction);
        double yy = RRayCast.getPointOnRayY(raycastVa, fraction);
        double zz = RRayCast.getPointOnRayZ(raycastVa, fraction);
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    private static native long createRRayCast(double var0, double var2, double var4, float var6, float var7, float var8);

    private static native void free(long var0);

    private static native float getDirectionX(long var0);

    private static native float getDirectionY(long var0);

    private static native float getDirectionZ(long var0);

    private static native double getOriginX(long var0);

    private static native double getOriginY(long var0);

    private static native double getOriginZ(long var0);

    private static native double getPointOnRayX(long var0, float var2);

    private static native double getPointOnRayY(long var0, float var2);

    private static native double getPointOnRayZ(long var0, float var2);
}

