/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AdditionalConstraint;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Part;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Ragdoll;
import com.github.stephengold.joltjni.RagdollResult;
import com.github.stephengold.joltjni.RagdollSettingsRef;
import com.github.stephengold.joltjni.Skeleton;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.template.RefTarget;

public class RagdollSettings
extends JoltPhysicsObject
implements RefTarget {
    public RagdollSettings() {
        long settingsVa = RagdollSettings.createDefault();
        long refVa = RagdollSettings.toRef(settingsVa);
        this.setVirtualAddress(settingsVa, () -> RagdollSettingsRef.free(refVa));
    }

    RagdollSettings(long settingsVa) {
        long refVa = RagdollSettings.toRef(settingsVa);
        this.setVirtualAddress(settingsVa, () -> RagdollSettingsRef.free(refVa));
    }

    public RagdollSettings(RagdollSettings original) {
        long originalVa = original.targetVa();
        long copyVa = RagdollSettings.createCopy(originalVa);
        long refVa = RagdollSettings.toRef(copyVa);
        this.setVirtualAddress(copyVa, () -> RagdollSettingsRef.free(refVa));
    }

    public void addAdditionalConstraint(AdditionalConstraint constraint) {
        long settingsVa = this.va();
        long constraintVa = constraint.va();
        RagdollSettings.addAdditionalConstraint(settingsVa, constraintVa);
    }

    public void calculateBodyIndexToConstraintIndex() {
        long settingsVa = this.va();
        RagdollSettings.calculateBodyIndexToConstraintIndex(settingsVa);
    }

    public void calculateConstraintIndexToBodyIdxPair() {
        long settingsVa = this.va();
        RagdollSettings.calculateConstraintIndexToBodyIdxPair(settingsVa);
    }

    public Ragdoll createRagdoll(int groupId, long userData, PhysicsSystem physicsSystem) {
        long systemVa;
        long settingsVa = this.va();
        long resultVa = RagdollSettings.createRagdoll(settingsVa, groupId, userData, systemVa = physicsSystem.va());
        Ragdoll result = resultVa == 0L ? null : new Ragdoll(resultVa, physicsSystem);
        return result;
    }

    public void disableParentChildCollisions() {
        long settingsVa = this.va();
        RagdollSettings.disableParentChildCollisions(settingsVa);
    }

    public Part[] getParts() {
        long settingsVa = this.va();
        int numParts = RagdollSettings.getNumParts(settingsVa);
        Part[] result = new Part[numParts];
        for (int partIndex = 0; partIndex < numParts; ++partIndex) {
            long partVa = RagdollSettings.getPart(settingsVa, partIndex);
            result[partIndex] = new Part(this, partVa);
        }
        return result;
    }

    public Skeleton getSkeleton() {
        long settingsVa = this.va();
        long skeletonVa = RagdollSettings.getSkeleton(settingsVa);
        Skeleton result = new Skeleton(skeletonVa);
        return result;
    }

    public void resizeParts(int numParts) {
        long settingsVa = this.va();
        RagdollSettings.resizeParts(settingsVa, numParts);
    }

    public void saveBinaryState(StreamOut stream, boolean saveShapes, boolean saveGroupFilter) {
        long settingsVa = this.targetVa();
        long streamVa = stream.va();
        RagdollSettings.saveBinaryState(settingsVa, streamVa, saveShapes, saveGroupFilter);
    }

    public void setSkeleton(Skeleton skeleton) {
        long settingsVa = this.va();
        long skeletonVa = skeleton.va();
        RagdollSettings.setSkeleton(settingsVa, skeletonVa);
    }

    public static RagdollResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.va();
        long resultVa = RagdollSettings.sRestoreFromBinaryState(streamVa);
        RagdollResult result = new RagdollResult(resultVa, true);
        return result;
    }

    public boolean stabilize() {
        long settingsVa = this.va();
        boolean result = RagdollSettings.stabilize(settingsVa);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = RagdollSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        RagdollSettings.setEmbedded(settingsVa);
    }

    @Override
    public RagdollSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = RagdollSettings.toRef(settingsVa);
        RagdollSettingsRef result = new RagdollSettingsRef(refVa, true);
        return result;
    }

    static native void addAdditionalConstraint(long var0, long var2);

    static native void calculateBodyIndexToConstraintIndex(long var0);

    static native void calculateConstraintIndexToBodyIdxPair(long var0);

    private static native long createCopy(long var0);

    private static native long createDefault();

    static native long createRagdoll(long var0, int var2, long var3, long var5);

    static native void disableParentChildCollisions(long var0);

    static native int getNumParts(long var0);

    static native long getPart(long var0, int var2);

    private static native int getRefCount(long var0);

    static native long getSkeleton(long var0);

    static native void resizeParts(long var0, int var2);

    static native void saveBinaryState(long var0, long var2, boolean var4, boolean var5);

    private static native void setEmbedded(long var0);

    static native void setSkeleton(long var0, long var2);

    static native long sRestoreFromBinaryState(long var0);

    static native boolean stabilize(long var0);

    private static native long toRef(long var0);
}

