/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class RayCast
extends JoltPhysicsObject {
    public RayCast(Vec3Arg startLocation, Vec3Arg offset) {
        float startX = startLocation.getX();
        float startY = startLocation.getY();
        float startZ = startLocation.getZ();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        long raycastVa = RayCast.createRayCast(startX, startY, startZ, dx, dy, dz);
        this.setVirtualAddress(raycastVa, () -> RayCast.free(raycastVa));
    }

    public Vec3 getDirection() {
        long raycastVa = this.va();
        float x = RayCast.getDirectionX(raycastVa);
        float y = RayCast.getDirectionY(raycastVa);
        float z = RayCast.getDirectionZ(raycastVa);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public Vec3 getOrigin() {
        long raycastVa = this.va();
        float x = RayCast.getOriginX(raycastVa);
        float y = RayCast.getOriginY(raycastVa);
        float z = RayCast.getOriginZ(raycastVa);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public Vec3 getPointOnRay(float fraction) {
        long raycastVa = this.va();
        float x = RayCast.getPointOnRayX(raycastVa, fraction);
        float y = RayCast.getPointOnRayY(raycastVa, fraction);
        float z = RayCast.getPointOnRayZ(raycastVa, fraction);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    private static native long createRayCast(float var0, float var1, float var2, float var3, float var4, float var5);

    private static native void free(long var0);

    private static native float getDirectionX(long var0);

    private static native float getDirectionY(long var0);

    private static native float getDirectionZ(long var0);

    private static native float getOriginX(long var0);

    private static native float getOriginY(long var0);

    private static native float getOriginZ(long var0);

    private static native float getPointOnRayX(long var0, float var2);

    private static native float getPointOnRayY(long var0, float var2);

    private static native float getPointOnRayZ(long var0, float var2);
}

