/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DecoratedShape;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class RotatedTranslatedShape
extends DecoratedShape {
    RotatedTranslatedShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public RotatedTranslatedShape(Vec3Arg offset, QuatArg rotation, ConstShape baseShape) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long baseShapeVa = baseShape.targetVa();
        long rtsVa = RotatedTranslatedShape.createRotatedTranslatedShape(offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, baseShapeVa);
        this.setVirtualAddressAsCoOwner(rtsVa);
    }

    public Vec3 getPosition() {
        long rtsVa = this.va();
        float offsetX = RotatedTranslatedShape.getPositionX(rtsVa);
        float offsetY = RotatedTranslatedShape.getPositionY(rtsVa);
        float offsetZ = RotatedTranslatedShape.getPositionZ(rtsVa);
        Vec3 result = new Vec3(offsetX, offsetY, offsetZ);
        return result;
    }

    public Quat getRotation() {
        long rtsVa = this.va();
        float rotW = RotatedTranslatedShape.getRotationW(rtsVa);
        float rotX = RotatedTranslatedShape.getRotationX(rtsVa);
        float rotY = RotatedTranslatedShape.getRotationY(rtsVa);
        float rotZ = RotatedTranslatedShape.getRotationZ(rtsVa);
        Quat result = new Quat(rotX, rotY, rotZ, rotW);
        return result;
    }

    private static native long createRotatedTranslatedShape(float var0, float var1, float var2, float var3, float var4, float var5, float var6, long var7);

    private static native float getPositionX(long var0);

    private static native float getPositionY(long var0);

    private static native float getPositionZ(long var0);

    private static native float getRotationW(long var0);

    private static native float getRotationX(long var0);

    private static native float getRotationY(long var0);

    private static native float getRotationZ(long var0);
}

