/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DecoratedShapeSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstShapeSettings;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class RotatedTranslatedShapeSettings
extends DecoratedShapeSettings {
    RotatedTranslatedShapeSettings(long rtssVa) {
        this.setVirtualAddressAsCoOwner(rtssVa, EShapeSubType.RotatedTranslated);
    }

    public RotatedTranslatedShapeSettings(QuatArg rotation, ConstShape baseShape) {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long baseShapeVa = baseShape.targetVa();
        long rtssVa = RotatedTranslatedShapeSettings.createSettingsFromShape(offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, baseShapeVa);
        this.setVirtualAddressAsCoOwner(rtssVa, EShapeSubType.RotatedTranslated);
    }

    public RotatedTranslatedShapeSettings(QuatArg rotation, ConstShapeSettings baseShapeSettings) {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long baseShapeSettingsVa = baseShapeSettings.targetVa();
        long rtssVa = RotatedTranslatedShapeSettings.createSettingsFromShapeSettings(offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, baseShapeSettingsVa);
        this.setVirtualAddressAsCoOwner(rtssVa, EShapeSubType.RotatedTranslated);
    }

    public RotatedTranslatedShapeSettings(RotatedTranslatedShapeSettings original) {
        long originalVa = original.va();
        long copyVa = RotatedTranslatedShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.RotatedTranslated);
    }

    public RotatedTranslatedShapeSettings(Vec3Arg offset, QuatArg rotation, ConstShape baseShape) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long baseShapeVa = baseShape.targetVa();
        long rtssVa = RotatedTranslatedShapeSettings.createSettingsFromShape(offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, baseShapeVa);
        this.setVirtualAddressAsCoOwner(rtssVa, EShapeSubType.RotatedTranslated);
    }

    public RotatedTranslatedShapeSettings(Vec3Arg offset, QuatArg rotation, ConstShapeSettings baseShapeSettings) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long baseShapeSettingsVa = baseShapeSettings.targetVa();
        long rtssVa = RotatedTranslatedShapeSettings.createSettingsFromShapeSettings(offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, baseShapeSettingsVa);
        this.setVirtualAddressAsCoOwner(rtssVa, EShapeSubType.RotatedTranslated);
    }

    public Vec3 getPosition() {
        long rtssVa = this.va();
        float offsetX = RotatedTranslatedShapeSettings.getPositionX(rtssVa);
        float offsetY = RotatedTranslatedShapeSettings.getPositionY(rtssVa);
        float offsetZ = RotatedTranslatedShapeSettings.getPositionZ(rtssVa);
        Vec3 result = new Vec3(offsetX, offsetY, offsetZ);
        return result;
    }

    public Quat getRotation() {
        long rtssVa = this.va();
        float rotW = RotatedTranslatedShapeSettings.getRotationW(rtssVa);
        float rotX = RotatedTranslatedShapeSettings.getRotationX(rtssVa);
        float rotY = RotatedTranslatedShapeSettings.getRotationY(rtssVa);
        float rotZ = RotatedTranslatedShapeSettings.getRotationZ(rtssVa);
        Quat result = new Quat(rotX, rotY, rotZ, rotW);
        return result;
    }

    public void setPosition(Vec3Arg offset) {
        long rtssVa = this.va();
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        RotatedTranslatedShapeSettings.setPosition(rtssVa, offsetX, offsetY, offsetZ);
    }

    public void setRotation(QuatArg rotation) {
        long rtssVa = this.va();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        RotatedTranslatedShapeSettings.setRotation(rtssVa, rotX, rotY, rotZ, rotW);
    }

    private static native long createCopy(long var0);

    private static native long createSettingsFromShape(float var0, float var1, float var2, float var3, float var4, float var5, float var6, long var7);

    private static native long createSettingsFromShapeSettings(float var0, float var1, float var2, float var3, float var4, float var5, float var6, long var7);

    private static native float getPositionX(long var0);

    private static native float getPositionY(long var0);

    private static native float getPositionZ(long var0);

    private static native float getRotationW(long var0);

    private static native float getRotationX(long var0);

    private static native float getRotationY(long var0);

    private static native float getRotationZ(long var0);

    private static native void setPosition(long var0, float var2, float var3, float var4);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5);
}

