/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DecoratedShapeSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstShapeSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class ScaledShapeSettings
extends DecoratedShapeSettings {
    public ScaledShapeSettings(ConstShape baseShape, Vec3Arg scaleFactors) {
        long baseShapeVa = baseShape.targetVa();
        float scaleX = scaleFactors.getX();
        float scaleY = scaleFactors.getY();
        float scaleZ = scaleFactors.getZ();
        long settingsVa = ScaledShapeSettings.createScaledShapeSettingsFromShape(baseShapeVa, scaleX, scaleY, scaleZ);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Scaled);
    }

    public ScaledShapeSettings(ConstShapeSettings baseSettings, Vec3Arg scaleFactors) {
        long baseSettingsVa = baseSettings.targetVa();
        float scaleX = scaleFactors.getX();
        float scaleY = scaleFactors.getY();
        float scaleZ = scaleFactors.getZ();
        long settingsVa = ScaledShapeSettings.createScaledShapeSettingsFromSettings(baseSettingsVa, scaleX, scaleY, scaleZ);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Scaled);
    }

    ScaledShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Scaled);
    }

    public ScaledShapeSettings(ScaledShapeSettings original) {
        long originalVa = original.va();
        long copyVa = ScaledShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Scaled);
    }

    public Vec3 getScale() {
        long scaledVa = this.va();
        float scaleX = ScaledShapeSettings.getScaleX(scaledVa);
        float scaleY = ScaledShapeSettings.getScaleY(scaledVa);
        float scaleZ = ScaledShapeSettings.getScaleZ(scaledVa);
        Vec3 result = new Vec3(scaleX, scaleY, scaleZ);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createScaledShapeSettingsFromSettings(long var0, float var2, float var3, float var4);

    private static native long createScaledShapeSettingsFromShape(long var0, float var2, float var3, float var4);

    private static native float getScaleX(long var0);

    private static native float getScaleY(long var0);

    private static native float getScaleZ(long var0);
}

