/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstTriangle;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class Triangle
extends JoltPhysicsObject
implements ConstTriangle {
    public Triangle() {
        long triangleVa = Triangle.createDefault();
        this.setVirtualAddress(triangleVa, () -> Triangle.free(triangleVa));
    }

    public Triangle(Float3 v1, Float3 v2, Float3 v3) {
        this(v1, v2, v3, 0);
    }

    public Triangle(Float3 v1, Float3 v2, Float3 v3, int materialIndex) {
        this(v1, v2, v3, materialIndex, 0);
    }

    public Triangle(Float3 v1, Float3 v2, Float3 v3, int materialIndex, int userData) {
        long triangleVa = Triangle.createTriangle(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, materialIndex, userData);
        this.setVirtualAddress(triangleVa, () -> Triangle.free(triangleVa));
    }

    public Triangle(ConstTriangle original) {
        long originalVa = original.targetVa();
        long copyVa = Triangle.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> Triangle.free(copyVa));
    }

    public Triangle(Vec3Arg v1, Vec3Arg v2, Vec3Arg v3) {
        this(v1, v2, v3, 0);
    }

    public Triangle(Vec3Arg v1, Vec3Arg v2, Vec3Arg v3, int materialIndex) {
        this(v1, v2, v3, materialIndex, 0);
    }

    public Triangle(Vec3Arg v1, Vec3Arg v2, Vec3Arg v3, int materialIndex, int userData) {
        float v1x = v1.getX();
        float v1y = v1.getY();
        float v1z = v1.getZ();
        float v2x = v2.getX();
        float v2y = v2.getY();
        float v2z = v2.getZ();
        float v3x = v3.getX();
        float v3y = v3.getY();
        float v3z = v3.getZ();
        long triangleVa = Triangle.createTriangle(v1x, v1y, v1z, v2x, v2y, v2z, v3x, v3y, v3z, materialIndex, userData);
        this.setVirtualAddress(triangleVa, () -> Triangle.free(triangleVa));
    }

    public void setMaterialIndex(int materialIndex) {
        long triangleVa = this.va();
        Triangle.setMaterialIndex(triangleVa, materialIndex);
    }

    public void setUserData(int value) {
        long triangleVa = this.va();
        Triangle.setUserData(triangleVa, value);
    }

    @Override
    public int getMaterialIndex() {
        long triangleVa = this.va();
        int result = Triangle.getMaterialIndex(triangleVa);
        return result;
    }

    @Override
    public int getUserData() {
        long triangleVa = this.va();
        int result = Triangle.getUserData(triangleVa);
        return result;
    }

    @Override
    public void putVertices(FloatBuffer storeBuffer) {
        long triangleVa = this.va();
        for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                float f = Triangle.getCoordinate(triangleVa, vertexIndex, axisIndex);
                storeBuffer.put(f);
            }
        }
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createTriangle(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, int var9, int var10);

    private static native void free(long var0);

    private static native float getCoordinate(long var0, int var2, int var3);

    private static native int getMaterialIndex(long var0);

    private static native int getUserData(long var0);

    private static native void setMaterialIndex(long var0, int var2);

    private static native void setUserData(long var0, int var2);
}

