/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.readonly.ConstVertex;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class Vertex
extends JoltPhysicsObject
implements ConstVertex {
    public Vertex() {
        long vertexVa = Vertex.createDefault();
        this.setVirtualAddress(vertexVa, () -> Vertex.free(vertexVa));
    }

    Vertex(JoltPhysicsObject container, long vertexVa) {
        super(container, vertexVa);
    }

    public Vertex setInvMass(float invMass) {
        long vertexVa = this.va();
        Vertex.setInvMass(vertexVa, invMass);
        return this;
    }

    public Vertex setPosition(float x, float y, float z) {
        long vertexVa = this.va();
        Vertex.setPosition(vertexVa, x, y, z);
        return this;
    }

    public Vertex setPosition(Float3 location) {
        long vertexVa = this.va();
        float x = location.x;
        float y = location.y;
        float z = location.z;
        Vertex.setPosition(vertexVa, x, y, z);
        return this;
    }

    public Vertex setPosition(Vec3Arg location) {
        long vertexVa = this.va();
        float x = location.getX();
        float y = location.getY();
        float z = location.getZ();
        Vertex.setPosition(vertexVa, x, y, z);
        return this;
    }

    public Vertex setVelocity(float x, float y, float z) {
        long vertexVa = this.va();
        Vertex.setVelocity(vertexVa, x, y, z);
        return this;
    }

    public Vertex setVelocity(Float3 velocity) {
        long vertexVa = this.va();
        float vx = velocity.x;
        float vy = velocity.y;
        float vz = velocity.z;
        Vertex.setVelocity(vertexVa, vx, vy, vz);
        return this;
    }

    public Vertex setVelocity(Vec3Arg velocity) {
        long vertexVa = this.va();
        float x = velocity.getX();
        float y = velocity.getY();
        float z = velocity.getZ();
        Vertex.setVelocity(vertexVa, x, y, z);
        return this;
    }

    @Override
    public float getInvMass() {
        long vertexVa = this.va();
        float result = Vertex.getInvMass(vertexVa);
        return result;
    }

    @Override
    public Float3 getPosition() {
        long vertexVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Vertex.getPosition(vertexVa, storeFloats);
        Float3 result = new Float3(storeFloats);
        return result;
    }

    @Override
    public Float3 getVelocity() {
        long vertexVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Vertex.getVelocity(vertexVa, storeFloats);
        Float3 result = new Float3(storeFloats);
        return result;
    }

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getInvMass(long var0);

    private static native void getPosition(long var0, FloatBuffer var2);

    private static native void getVelocity(long var0, FloatBuffer var2);

    private static native void setInvMass(long var0, float var2);

    private static native void setPosition(long var0, float var2, float var3, float var4);

    private static native void setVelocity(long var0, float var2, float var3, float var4);
}

