/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.std;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.std.DefaultRandomEngine;
import com.github.stephengold.joltjni.std.Mt19937;
import com.github.stephengold.joltjni.std.RandomNumberEngine;

public class UniformFloatDistribution
extends JoltPhysicsObject {
    public UniformFloatDistribution(float min, float max) {
        long distributionVa = UniformFloatDistribution.createDistribution(min, max);
        this.setVirtualAddress(distributionVa, () -> UniformFloatDistribution.free(distributionVa));
    }

    public float nextFloat(RandomNumberEngine generator) {
        float result;
        long distributionVa = this.va();
        long generatorVa = generator.targetVa();
        if (generator instanceof DefaultRandomEngine) {
            result = UniformFloatDistribution.nextFloatDre(distributionVa, generatorVa);
        } else if (generator instanceof Mt19937) {
            result = UniformFloatDistribution.nextFloat(distributionVa, generatorVa);
        } else {
            String className = generator.getClass().getSimpleName();
            throw new IllegalArgumentException("className = " + className);
        }
        return result;
    }

    private static native long createDistribution(float var0, float var1);

    private static native void free(long var0);

    private static native float nextFloat(long var0, long var2);

    private static native float nextFloatDre(long var0, long var2);
}

