/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.vhacd;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.vhacd.FillMode;
import java.util.Objects;

public class Parameters
extends JoltPhysicsObject {
    private boolean enableDebugOutput;

    public Parameters() {
        long parametersVa = Parameters.createDefault();
        this.setVirtualAddress(parametersVa, () -> Parameters.free(parametersVa));
    }

    public Parameters(Parameters original) {
        long originalVa = original.va();
        long copyVa = Parameters.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> Parameters.free(copyVa));
        this.enableDebugOutput = original.isDebugOutputEnabled();
    }

    public boolean getAsyncAcd() {
        long parametersVa = this.va();
        boolean result = Parameters.getAsyncAcd(parametersVa);
        return result;
    }

    public FillMode getFillMode() {
        long parametersVa = this.va();
        int ordinal = Parameters.getFillMode(parametersVa);
        FillMode result = FillMode.values()[ordinal];
        return result;
    }

    public boolean getFindBestPlane() {
        long parametersVa = this.va();
        boolean result = Parameters.getFindBestPlane(parametersVa);
        return result;
    }

    public int getMaxConvexHulls() {
        long parametersVa = this.va();
        int result = Parameters.getMaxConvexHulls(parametersVa);
        return result;
    }

    public int getMaxNumVerticesPerCh() {
        long parametersVa = this.va();
        int result = Parameters.getMaxNumVerticesPerCh(parametersVa);
        return result;
    }

    public int getMaxRecursionDepth() {
        long parametersVa = this.va();
        int result = Parameters.getMaxRecursionDepth(parametersVa);
        return result;
    }

    public int getMinEdgeLength() {
        long parametersVa = this.va();
        int result = Parameters.getMinEdgeLength(parametersVa);
        return result;
    }

    public double getMinimumVolumePercentErrorAllowed() {
        long parametersVa = this.va();
        double result = Parameters.getMinimumVolumePercentErrorAllowed(parametersVa);
        return result;
    }

    public int getResolution() {
        long parametersVa = this.va();
        int result = Parameters.getResolution(parametersVa);
        return result;
    }

    public boolean getShrinkWrap() {
        long parametersVa = this.va();
        boolean result = Parameters.getShrinkWrap(parametersVa);
        return result;
    }

    public boolean isDebugOutputEnabled() {
        return this.enableDebugOutput;
    }

    public Parameters setAsyncAcd(boolean setting) {
        long parametersVa = this.va();
        Parameters.setAsyncAcd(parametersVa, setting);
        return this;
    }

    public Parameters setDebugOutputEnabled(boolean setting) {
        this.enableDebugOutput = setting;
        return this;
    }

    public Parameters setFillMode(FillMode mode) {
        long parametersVa = this.va();
        int ordinal = mode.ordinal();
        Parameters.setFillMode(parametersVa, ordinal);
        return this;
    }

    public Parameters setFindBestPlane(boolean setting) {
        long parameterVa = this.va();
        Parameters.setFindBestPlane(parameterVa, setting);
        return this;
    }

    public Parameters setMaxConvexHulls(int number) {
        assert (number >= 1 && number <= 1024) : "number = " + number;
        long parameterVa = this.va();
        Parameters.setMaxConvexHulls(parameterVa, number);
        return this;
    }

    public Parameters setMaxNumVerticesPerCh(int number) {
        assert (number >= 4 && number <= 2048) : "number = " + number;
        long parameterVa = this.va();
        Parameters.setMaxNumVerticesPerCh(parameterVa, number);
        return this;
    }

    public Parameters setMaxRecursionDepth(int depth) {
        assert (depth >= 2 && depth <= 64) : "depth = " + depth;
        long parameterVa = this.va();
        Parameters.setMaxRecursionDepth(parameterVa, depth);
        return this;
    }

    public Parameters setMinEdgeLength(int length) {
        assert (length >= 1 && length <= 32) : "length = " + length;
        long parametersVa = this.va();
        Parameters.setMinEdgeLength(parametersVa, length);
        return this;
    }

    public Parameters setMinimumVolumePercentErrorAllowed(double percentage) {
        assert (percentage >= 0.0 && percentage <= 100.0) : "percentage" + percentage;
        long parameterVa = this.va();
        Parameters.setMinimumVolumePercentErrorAllowed(parameterVa, percentage);
        return this;
    }

    public Parameters setResolution(int maxVoxels) {
        assert (maxVoxels >= 10000 && maxVoxels <= 64000000) : "maxVoxels = " + maxVoxels;
        long parametersVa = this.va();
        Parameters.setResolution(parametersVa, maxVoxels);
        return this;
    }

    public Parameters setShrinkWrap(boolean setting) {
        long parameterVa = this.va();
        Parameters.setShrinkWrap(parameterVa, setting);
        return this;
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            Parameters other = (Parameters)otherObject;
            result = this.getAsyncAcd() == other.getAsyncAcd() && this.getFillMode() == other.getFillMode() && this.getFindBestPlane() == other.getFindBestPlane() && this.getMaxConvexHulls() == other.getMaxConvexHulls() && this.getMaxNumVerticesPerCh() == other.getMaxNumVerticesPerCh() && this.getMaxRecursionDepth() == other.getMaxRecursionDepth() && this.getMinEdgeLength() == other.getMinEdgeLength() && this.getMinimumVolumePercentErrorAllowed() == other.getMinimumVolumePercentErrorAllowed() && this.getResolution() == other.getResolution() && this.getShrinkWrap() == other.getShrinkWrap() && this.isDebugOutputEnabled() == other.isDebugOutputEnabled();
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{this.getAsyncAcd(), this.getFillMode(), this.getFindBestPlane(), this.getMaxConvexHulls(), this.getMaxNumVerticesPerCh(), this.getMaxRecursionDepth(), this.getMinEdgeLength(), this.getMinimumVolumePercentErrorAllowed(), this.getResolution(), this.getShrinkWrap(), this.isDebugOutputEnabled()});
        return result;
    }

    @Override
    public String toString() {
        String result = String.format("Parameters[%n async=%s  debug=%s  %s  findBest=%s%n maxHulls=%s  maxRecursion=%s  maxVerticesPH=%s  minEdge=%s%n resolution=%s  shrink=%s  volumeErr=%s%%%n]", new Object[]{this.getAsyncAcd(), this.isDebugOutputEnabled(), this.getFillMode(), this.getFindBestPlane(), this.getMaxConvexHulls(), this.getMaxRecursionDepth(), this.getMaxNumVerticesPerCh(), this.getMinEdgeLength(), this.getResolution(), this.getShrinkWrap(), this.getMinimumVolumePercentErrorAllowed()});
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native boolean getAsyncAcd(long var0);

    private static native int getFillMode(long var0);

    private static native boolean getFindBestPlane(long var0);

    private static native int getMaxConvexHulls(long var0);

    private static native int getMaxNumVerticesPerCh(long var0);

    private static native int getMaxRecursionDepth(long var0);

    private static native int getMinEdgeLength(long var0);

    private static native double getMinimumVolumePercentErrorAllowed(long var0);

    private static native int getResolution(long var0);

    private static native boolean getShrinkWrap(long var0);

    private static native void setAsyncAcd(long var0, boolean var2);

    private static native void setFillMode(long var0, int var2);

    private static native void setFindBestPlane(long var0, boolean var2);

    private static native void setMaxConvexHulls(long var0, int var2);

    private static native void setMaxNumVerticesPerCh(long var0, int var2);

    private static native void setMaxRecursionDepth(long var0, int var2);

    private static native void setMinEdgeLength(long var0, int var2);

    private static native void setMinimumVolumePercentErrorAllowed(long var0, double var2);

    private static native void setResolution(long var0, int var2);

    private static native void setShrinkWrap(long var0, boolean var2);
}

