/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.builtin.block.BlockClientRigidBody;
import net.xmx.velthoric.builtin.block.BlockRigidBody;
import net.xmx.velthoric.builtin.box.BoxClientRigidBody;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.builtin.cloth.ClothClientSoftBody;
import net.xmx.velthoric.builtin.cloth.ClothSoftBody;
import net.xmx.velthoric.builtin.drivable.CarImpl;
import net.xmx.velthoric.builtin.drivable.MotorcycleImpl;
import net.xmx.velthoric.builtin.marble.MarbleClientRigidBody;
import net.xmx.velthoric.builtin.marble.MarbleRigidBody;
import net.xmx.velthoric.builtin.rope.RopeClientSoftBody;
import net.xmx.velthoric.builtin.rope.RopeSoftBody;
import net.xmx.velthoric.builtin.sphere.SphereClientRigidBody;
import net.xmx.velthoric.builtin.sphere.SphereRigidBody;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.registry.VxObjectRegistry;
import net.xmx.velthoric.physics.vehicle.type.car.VxClientCar;
import net.xmx.velthoric.physics.vehicle.type.motorcycle.VxClientMotorcycle;

public class VxRegisteredObjects {
    public static final VxObjectType<BlockRigidBody> BLOCK = VxObjectType.Builder.create(BlockRigidBody::new).noSummon().build(new ResourceLocation("velthoric", "block"));
    public static final VxObjectType<SphereRigidBody> SPHERE = VxObjectType.Builder.create(SphereRigidBody::new).build(new ResourceLocation("velthoric", "sphere"));
    public static final VxObjectType<BoxRigidBody> BOX = VxObjectType.Builder.create(BoxRigidBody::new).build(new ResourceLocation("velthoric", "box"));
    public static final VxObjectType<MarbleRigidBody> MARBLE = VxObjectType.Builder.create(MarbleRigidBody::new).build(new ResourceLocation("velthoric", "marble"));
    public static final VxObjectType<ClothSoftBody> CLOTH = VxObjectType.Builder.create(ClothSoftBody::new).build(new ResourceLocation("velthoric", "cloth"));
    public static final VxObjectType<RopeSoftBody> ROPE = VxObjectType.Builder.create(RopeSoftBody::new).build(new ResourceLocation("velthoric", "rope"));
    public static final VxObjectType<CarImpl> CAR = VxObjectType.Builder.create(CarImpl::new).build(new ResourceLocation("velthoric", "car"));
    public static final VxObjectType<MotorcycleImpl> MOTORCYCLE = VxObjectType.Builder.create(MotorcycleImpl::new).build(new ResourceLocation("velthoric", "motorcycle"));

    public static void register() {
        VxObjectRegistry registry = VxObjectRegistry.getInstance();
        registry.register(BLOCK);
        registry.register(SPHERE);
        registry.register(BOX);
        registry.register(MARBLE);
        registry.register(CLOTH);
        registry.register(ROPE);
        registry.register(CAR);
        registry.register(MOTORCYCLE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClientFactories() {
        VxObjectRegistry registry = VxObjectRegistry.getInstance();
        registry.registerClientFactory(BLOCK.getTypeId(), BlockClientRigidBody::new);
        registry.registerClientFactory(SPHERE.getTypeId(), SphereClientRigidBody::new);
        registry.registerClientFactory(BOX.getTypeId(), BoxClientRigidBody::new);
        registry.registerClientFactory(MARBLE.getTypeId(), MarbleClientRigidBody::new);
        registry.registerClientFactory(CLOTH.getTypeId(), ClothClientSoftBody::new);
        registry.registerClientFactory(ROPE.getTypeId(), RopeClientSoftBody::new);
        registry.registerClientFactory(CAR.getTypeId(), VxClientCar::new);
        registry.registerClientFactory(MOTORCYCLE.getTypeId(), VxClientMotorcycle::new);
    }
}

