/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.box;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.state.BlockState;
import net.xmx.velthoric.builtin.box.BoxColor;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientRigidBody;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;
import org.joml.Quaternionf;

public class BoxClientRigidBody
extends VxClientRigidBody {
    private static final VxDataAccessor<Vec3> DATA_HALF_EXTENTS = VxDataAccessor.create(BoxClientRigidBody.class, VxDataSerializers.VEC3);
    private static final VxDataAccessor<Integer> DATA_COLOR_ORDINAL = VxDataAccessor.create(BoxClientRigidBody.class, VxDataSerializers.INTEGER);

    public BoxClientRigidBody(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        super(id, manager, dataStoreIndex, objectType);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_HALF_EXTENTS, new Vec3(0.5f, 0.5f, 0.5f));
        this.synchronizedData.define(DATA_COLOR_ORDINAL, BoxColor.RED.ordinal());
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        int colorOrdinal = this.getSyncData(DATA_COLOR_ORDINAL);
        BoxColor color = colorOrdinal >= 0 && colorOrdinal < BoxColor.values().length ? BoxColor.values()[colorOrdinal] : BoxColor.RED;
        BlockState blockState = color.getBlock().m_49966_();
        Vec3 halfExtents = this.getSyncData(DATA_HALF_EXTENTS);
        float hx = halfExtents.getX();
        float hy = halfExtents.getY();
        float hz = halfExtents.getZ();
        float fullWidth = hx * 2.0f;
        float fullHeight = hy * 2.0f;
        float fullDepth = hz * 2.0f;
        poseStack.m_85836_();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.m_252880_(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.m_252781_(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        poseStack.m_252880_(-hx, -hy, -hz);
        poseStack.m_85841_(fullWidth, fullHeight, fullDepth);
        Minecraft.m_91087_().m_91289_().m_110912_(blockState, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }
}

