/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.marble;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientRigidBody;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MarbleClientRigidBody
extends VxClientRigidBody {
    private static final VxDataAccessor<Float> DATA_RADIUS = VxDataAccessor.create(MarbleClientRigidBody.class, VxDataSerializers.FLOAT);
    private static final ItemStack MARBLE_ITEM_STACK = new ItemStack((ItemLike)Items.f_42542_);

    public MarbleClientRigidBody(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        super(id, manager, dataStoreIndex, objectType);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_RADIUS, Float.valueOf(0.15f));
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.m_85836_();
        float radius = this.getSyncData(DATA_RADIUS).floatValue();
        RVec3 renderPosition = renderState.transform.getTranslation();
        poseStack.m_252880_(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        BakedModel itemModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(MARBLE_ITEM_STACK);
        TextureAtlasSprite sprite = itemModel.m_6160_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        this.addVertex(vertexConsumer, matrix4f, matrix3f, -radius, -radius, sprite.m_118409_(), sprite.m_118412_(), packedLight);
        this.addVertex(vertexConsumer, matrix4f, matrix3f, radius, -radius, sprite.m_118410_(), sprite.m_118412_(), packedLight);
        this.addVertex(vertexConsumer, matrix4f, matrix3f, radius, radius, sprite.m_118410_(), sprite.m_118411_(), packedLight);
        this.addVertex(vertexConsumer, matrix4f, matrix3f, -radius, radius, sprite.m_118409_(), sprite.m_118411_(), packedLight);
        poseStack.m_85849_();
    }

    private void addVertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, float x, float y, float u, float v, int packedLight) {
        consumer.m_252986_(pose, x, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

