/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.sphere;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientRigidBody;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SphereClientRigidBody
extends VxClientRigidBody {
    private static final VxDataAccessor<Float> DATA_RADIUS = VxDataAccessor.create(SphereClientRigidBody.class, VxDataSerializers.FLOAT);
    private static final int STACKS = 16;
    private static final int SECTORS = 32;

    public SphereClientRigidBody(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        super(id, manager, dataStoreIndex, objectType);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(DATA_RADIUS, Float.valueOf(0.5f));
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.m_85836_();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.m_252880_(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.m_252781_(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        PoseStack.Pose lastPose = poseStack.m_85850_();
        Matrix4f poseMatrix = lastPose.m_252922_();
        Matrix3f normalMatrix = lastPose.m_252943_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110451_());
        float radius = this.getSyncData(DATA_RADIUS).floatValue();
        int r = 200;
        int g = 50;
        int b = 50;
        int a = 255;
        for (int i = 0; i < 16; ++i) {
            float phi1 = (float)((double)i * Math.PI / 16.0);
            float phi2 = (float)((double)(i + 1) * Math.PI / 16.0);
            for (int j = 0; j < 32; ++j) {
                float theta1 = (float)((double)(j * 2) * Math.PI / 32.0);
                float theta2 = (float)((double)((j + 1) * 2) * Math.PI / 32.0);
                Vector3f v1 = this.getSphereVertex(radius, phi1, theta1);
                Vector3f v2 = this.getSphereVertex(radius, phi1, theta2);
                Vector3f v3 = this.getSphereVertex(radius, phi2, theta2);
                Vector3f v4 = this.getSphereVertex(radius, phi2, theta1);
                this.addVertex(consumer, poseMatrix, normalMatrix, v1, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v2, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v4, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v2, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v3, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v4, r, g, b, a, packedLight);
            }
        }
        poseStack.m_85849_();
    }

    private Vector3f getSphereVertex(float radius, float phi, float theta) {
        float x = (float)((double)radius * Math.sin(phi) * Math.cos(theta));
        float y = (float)((double)radius * Math.cos(phi));
        float z = (float)((double)radius * Math.sin(phi) * Math.sin(theta));
        return new Vector3f(x, y, z);
    }

    private void addVertex(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, Vector3f pos, int r, int g, int b, int a, int packedLight) {
        Vector3f normal = new Vector3f((Vector3fc)pos).normalize();
        consumer.m_252986_(poseMatrix, pos.x, pos.y, pos.z).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, normal.x, normal.y, normal.z).m_5752_();
    }
}

