/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.registry.VxObjectRegistry;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxSummonCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vxsummon").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> {
            VxObjectRegistry registry = VxObjectRegistry.getInstance();
            return SharedSuggestionProvider.m_82981_(registry.getRegisteredTypes().values().stream().filter(VxObjectType::isSummonable).map(type -> type.getTypeId().toString()), (SuggestionsBuilder)builder);
        }).then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120847_((boolean)true)).executes(VxSummonCommand::execute))).executes(VxSummonCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Vec3 pos;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        try {
            pos = Vec3Argument.m_120844_(context, (String)"position");
        }
        catch (IllegalArgumentException e) {
            pos = source.m_81371_();
        }
        ResourceLocation typeId = ResourceLocationArgument.m_107011_(context, (String)"type");
        VxObjectType<?> type = VxObjectRegistry.getInstance().getRegistrationData(typeId);
        if (type == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Physics object type not found: " + String.valueOf(typeId))));
            return 0;
        }
        if (!type.isSummonable()) {
            source.m_81352_((Component)Component.m_237113_((String)("Physics object type '" + String.valueOf(typeId) + "' cannot be summoned.")));
            return 0;
        }
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (world == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        VxObjectManager manager = world.getObjectManager();
        VxTransform transform = new VxTransform(new RVec3(pos.f_82479_, pos.f_82480_, pos.f_82481_), Quat.sIdentity());
        Object body = type.create(world, UUID.randomUUID());
        if (body == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to create an instance of " + String.valueOf(typeId))));
            return 0;
        }
        manager.addConstructedBody((VxBody)body, EActivation.Activate, transform);
        source.m_288197_(() -> Component.m_237113_((String)String.format("Successfully summoned physics object '%s' with ID: %s", typeId, body.getPhysicsId())), true);
        return 1;
    }
}

