/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.argument;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxObjectSelector {
    private final int limit;
    private final MinMaxBounds.Doubles distance;
    @Nullable
    private final ResourceLocation type;
    private final boolean typeInverse;
    @Nullable
    private final EBodyType bodyType;
    private final BiConsumer<Vec3, List<VxBody>> order;

    public VxObjectSelector(int limit, MinMaxBounds.Doubles distance, @Nullable ResourceLocation type, boolean typeInverse, @Nullable EBodyType bodyType, BiConsumer<Vec3, List<VxBody>> order) {
        this.limit = limit;
        this.distance = distance;
        this.type = type;
        this.typeInverse = typeInverse;
        this.bodyType = bodyType;
        this.order = order;
    }

    private Predicate<VxBody> buildPredicate(CommandSourceStack source) {
        Vec3 sourcePos = source.m_81371_();
        Predicate<VxBody> predicate = obj -> true;
        if (this.type != null) {
            predicate = predicate.and(obj -> obj.getType().getTypeId().equals((Object)this.type) != this.typeInverse);
        }
        if (this.bodyType != null) {
            predicate = predicate.and(obj -> {
                int index = obj.getDataStoreIndex();
                if (index != -1) {
                    return obj.getWorld().getObjectManager().getDataStore().bodyType[index] == this.bodyType;
                }
                return false;
            });
        }
        if (!this.distance.m_55327_()) {
            predicate = predicate.and(obj -> {
                RVec3 objPos = obj.getTransform().getTranslation();
                return this.distance.m_154812_(sourcePos.m_82531_((double)objPos.x(), (double)objPos.y(), (double)objPos.z()));
            });
        }
        return predicate;
    }

    public List<VxBody> select(CommandSourceStack source) {
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)source.m_81372_().m_46472_());
        if (world == null) {
            return Collections.emptyList();
        }
        Predicate<VxBody> predicate = this.buildPredicate(source);
        ArrayList<VxBody> allObjects = new ArrayList<VxBody>(world.getObjectManager().getAllObjects());
        ArrayList<VxBody> filteredObjects = new ArrayList<VxBody>();
        for (VxBody obj : allObjects) {
            if (!predicate.test(obj)) continue;
            filteredObjects.add(obj);
        }
        this.order.accept(source.m_81371_(), filteredObjects);
        if (filteredObjects.size() <= this.limit) {
            return filteredObjects;
        }
        return filteredObjects.subList(0, this.limit);
    }
}

