/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.argument;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.command.argument.VxObjectSelector;
import net.xmx.velthoric.physics.object.registry.VxObjectRegistry;
import net.xmx.velthoric.physics.object.type.VxBody;
import org.jetbrains.annotations.Nullable;

public class VxObjectSelectorParser {
    public static final SimpleCommandExceptionType ERROR_MISSING_SELECTOR_TYPE = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Missing selector type"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_SELECTOR_TYPE = new DynamicCommandExceptionType(obj -> Component.m_237113_((String)("Unknown selector type '" + String.valueOf(obj) + "'")));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_END_OF_OPTIONS = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Expected ']' to end selector options"));
    public static final DynamicCommandExceptionType ERROR_EXPECTED_OPTION_VALUE = new DynamicCommandExceptionType(obj -> Component.m_237113_((String)("Expected value for option '" + String.valueOf(obj) + "'")));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OPTION = new DynamicCommandExceptionType(obj -> Component.m_237113_((String)("Unknown option '" + String.valueOf(obj) + "'")));
    public static final DynamicCommandExceptionType ERROR_INVALID_BODY_TYPE = new DynamicCommandExceptionType(obj -> Component.m_237113_((String)("Unknown body type '" + String.valueOf(obj) + "'")));
    public static final DynamicCommandExceptionType ERROR_INVALID_SORT_TYPE = new DynamicCommandExceptionType(obj -> Component.m_237113_((String)("Unknown sort type '" + String.valueOf(obj) + "'")));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OBJECT_TYPE = new DynamicCommandExceptionType(obj -> Component.m_237113_((String)("Unknown object type '" + String.valueOf(obj) + "'")));
    private static final List<String> OPTION_KEYS = Arrays.asList("limit", "distance", "type", "bodytype", "sort");
    public static final BiConsumer<Vec3, List<VxBody>> ORDER_NEAREST_VX = (sourcePos, list) -> list.sort((a, b) -> {
        RVec3 posA = a.getTransform().getTranslation();
        RVec3 posB = b.getTransform().getTranslation();
        return Doubles.compare((double)sourcePos.m_82531_((double)posA.x(), (double)posA.y(), (double)posA.z()), (double)sourcePos.m_82531_((double)posB.x(), (double)posB.y(), (double)posB.z()));
    });
    public static final BiConsumer<Vec3, List<VxBody>> ORDER_FURTHEST_VX = (sourcePos, list) -> list.sort((a, b) -> {
        RVec3 posA = a.getTransform().getTranslation();
        RVec3 posB = b.getTransform().getTranslation();
        return Doubles.compare((double)sourcePos.m_82531_((double)posB.x(), (double)posB.y(), (double)posB.z()), (double)sourcePos.m_82531_((double)posA.x(), (double)posA.y(), (double)posA.z()));
    });
    public static final BiConsumer<Vec3, List<VxBody>> ORDER_RANDOM_VX = (sourcePos, list) -> Collections.shuffle(list);
    private final StringReader reader;
    private int limit = Integer.MAX_VALUE;
    private MinMaxBounds.Doubles distance = MinMaxBounds.Doubles.f_154779_;
    @Nullable
    private ResourceLocation type;
    private boolean typeInverse = false;
    @Nullable
    private EBodyType bodyType;
    private BiConsumer<Vec3, List<VxBody>> order = (pos, list) -> {};
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestions = (b, c) -> b.buildFuture();

    public VxObjectSelectorParser(StringReader reader) {
        this.reader = reader;
    }

    public VxObjectSelector parse() throws CommandSyntaxException {
        this.suggestions = this::suggestSelector;
        if (!this.reader.canRead() || this.reader.peek() != '@') {
            throw ERROR_MISSING_SELECTOR_TYPE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
        this.suggestions = this::suggestSelectorType;
        if (!this.reader.canRead()) {
            throw ERROR_MISSING_SELECTOR_TYPE.createWithContext((ImmutableStringReader)this.reader);
        }
        char selectorChar = this.reader.read();
        if (selectorChar != 'x') {
            this.reader.setCursor(this.reader.getCursor() - 1);
            throw ERROR_UNKNOWN_SELECTOR_TYPE.createWithContext((ImmutableStringReader)this.reader, (Object)("@" + selectorChar));
        }
        this.suggestions = this::suggestOpenOptions;
        if (this.reader.canRead() && this.reader.peek() == '[') {
            this.reader.skip();
            this.suggestions = this::suggestOptionsKeyOrClose;
            this.parseOptions();
        }
        return new VxObjectSelector(this.limit, this.distance, this.type, this.typeInverse, this.bodyType, this.order);
    }

    private void parseOptions() throws CommandSyntaxException {
        this.suggestions = this::suggestOptionsKey;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int cursorBeforeOption = this.reader.getCursor();
            String optionName = this.reader.readString();
            this.reader.skipWhitespace();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                this.reader.setCursor(cursorBeforeOption);
                throw ERROR_EXPECTED_OPTION_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)optionName);
            }
            this.suggestions = this::suggestEquals;
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = (builder, consumer) -> this.suggestOptionValues(optionName, (SuggestionsBuilder)builder);
            this.parseOptionValue(optionName);
            this.reader.skipWhitespace();
            this.suggestions = this::suggestOptionsNextOrClose;
            if (!this.reader.canRead() || this.reader.peek() != ',') break;
            this.reader.skip();
            this.suggestions = this::suggestOptionsKey;
        }
        if (!this.reader.canRead() || this.reader.read() != ']') {
            throw ERROR_EXPECTED_END_OF_OPTIONS.createWithContext((ImmutableStringReader)this.reader);
        }
        this.suggestions = (b, c) -> b.buildFuture();
    }

    private void parseOptionValue(String name) throws CommandSyntaxException {
        int cursor = this.reader.getCursor();
        block7 : switch (name) {
            case "limit": {
                this.limit = this.reader.readInt();
                break;
            }
            case "distance": {
                this.distance = MinMaxBounds.Doubles.m_154793_((StringReader)this.reader);
                break;
            }
            case "type": {
                if (this.reader.canRead() && this.reader.peek() == '!') {
                    this.typeInverse = true;
                    this.reader.skip();
                }
                int valueStartCursor = this.reader.getCursor();
                ResourceLocation parsedLocation = ResourceLocation.m_135818_((StringReader)this.reader);
                if (parsedLocation.m_135815_().isEmpty()) {
                    this.reader.setCursor(valueStartCursor);
                    throw ERROR_EXPECTED_OPTION_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)name);
                }
                if (VxObjectRegistry.getInstance().getRegistrationData(parsedLocation) == null) {
                    this.reader.setCursor(valueStartCursor);
                    throw ERROR_UNKNOWN_OBJECT_TYPE.createWithContext((ImmutableStringReader)this.reader, (Object)parsedLocation.toString());
                }
                this.type = parsedLocation;
                break;
            }
            case "bodytype": {
                String bodyTypeName = this.reader.readString();
                Optional<EBodyType> match = Arrays.stream(EBodyType.values()).filter(e -> e.name().equalsIgnoreCase(bodyTypeName)).findFirst();
                if (match.isPresent()) {
                    this.bodyType = match.get();
                    break;
                }
                this.reader.setCursor(cursor);
                throw ERROR_INVALID_BODY_TYPE.createWithContext((ImmutableStringReader)this.reader, (Object)bodyTypeName);
            }
            case "sort": {
                String sortType = this.reader.readString();
                switch (sortType.toLowerCase()) {
                    case "nearest": {
                        this.order = ORDER_NEAREST_VX;
                        break block7;
                    }
                    case "furthest": {
                        this.order = ORDER_FURTHEST_VX;
                        break block7;
                    }
                    case "random": {
                        this.order = ORDER_RANDOM_VX;
                        break block7;
                    }
                }
                this.reader.setCursor(cursor);
                throw ERROR_INVALID_SORT_TYPE.createWithContext((ImmutableStringReader)this.reader, (Object)sortType);
            }
            default: {
                this.reader.setCursor(cursor);
                throw ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)this.reader, (Object)name);
            }
        }
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        return this.suggestions.apply(builder.createOffset(this.reader.getCursor()), consumer);
    }

    private CompletableFuture<Suggestions> suggestSelector(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest("@x");
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestSelectorType(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest("x");
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenOptions(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest("[");
        return builder.buildFuture();
    }

    private void suggestOptionKeys(SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        for (String key : OPTION_KEYS) {
            if (!key.toLowerCase().startsWith(remaining)) continue;
            builder.suggest(key + "=");
        }
    }

    private CompletableFuture<Suggestions> suggestOptionsKeyOrClose(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest("]");
        this.suggestOptionKeys(builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOptionsKey(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        this.suggestOptionKeys(builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOptionsNextOrClose(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(",");
        builder.suggest("]");
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest("=");
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOptionValues(String option, SuggestionsBuilder builder) {
        switch (option) {
            case "type": {
                Stream<String> keys = VxObjectRegistry.getInstance().getRegisteredTypes().keySet().stream().map(ResourceLocation::toString);
                String remaining = builder.getRemaining();
                if (remaining.isEmpty()) {
                    builder.suggest("!");
                }
                if (remaining.startsWith("!")) {
                    SuggestionsBuilder subBuilder = builder.createOffset(builder.getStart() + 1);
                    SharedSuggestionProvider.m_82981_(keys, (SuggestionsBuilder)subBuilder);
                    return builder.add(subBuilder).buildFuture();
                }
                SharedSuggestionProvider.m_82981_(keys, (SuggestionsBuilder)builder);
                break;
            }
            case "bodytype": {
                SharedSuggestionProvider.m_82981_(Arrays.stream(EBodyType.values()).map(e -> e.name().toLowerCase()), (SuggestionsBuilder)builder);
                break;
            }
            case "sort": {
                SharedSuggestionProvider.m_82967_((String[])new String[]{"nearest", "furthest", "random"}, (SuggestionsBuilder)builder);
            }
        }
        return builder.buildFuture();
    }
}

