/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.cloth.ClothSoftBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class SpawnClothTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnCloth";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120847_((boolean)true)).then(Commands.m_82129_((String)"width", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(Commands.m_82129_((String)"height", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(Commands.m_82129_((String)"mass", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(Commands.m_82129_((String)"segmentsWidth", (ArgumentType)IntegerArgumentType.integer((int)2, (int)50)).then(Commands.m_82129_((String)"segmentsHeight", (ArgumentType)IntegerArgumentType.integer((int)2, (int)50)).executes(this::execute)))))));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        VxTransform transform;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        Vec3 pos = Vec3Argument.m_120844_(context, (String)"pos");
        float width = FloatArgumentType.getFloat(context, (String)"width");
        float height = FloatArgumentType.getFloat(context, (String)"height");
        float mass = FloatArgumentType.getFloat(context, (String)"mass");
        int segmentsWidth = IntegerArgumentType.getInteger(context, (String)"segmentsWidth");
        int segmentsHeight = IntegerArgumentType.getInteger(context, (String)"segmentsHeight");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (physicsWorld == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        VxObjectManager manager = physicsWorld.getObjectManager();
        ClothSoftBody spawnedCloth = manager.createSoftBody(VxRegisteredObjects.CLOTH, transform = new VxTransform(new RVec3(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()), Quat.sIdentity()), cloth -> cloth.setConfiguration(segmentsWidth, segmentsHeight, width, height, mass, 0.001f));
        if (spawnedCloth != null) {
            source.m_288197_(() -> Component.m_237113_((String)"Successfully spawned cloth."), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"Failed to spawn the cloth. Check server logs."));
        return 0;
    }
}

