/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.marble.MarbleRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class SpawnMarbleTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnMarble";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120847_((boolean)true)).executes(this::execute)).then(Commands.m_82129_((String)"radius", (ArgumentType)FloatArgumentType.floatArg((float)0.05f)).executes(this::executeWithRadius)));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.spawnMarble(context, 0.15f);
    }

    private int executeWithRadius(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float radius = FloatArgumentType.getFloat(context, (String)"radius");
        return this.spawnMarble(context, radius);
    }

    private int spawnMarble(CommandContext<CommandSourceStack> context, float radius) throws CommandSyntaxException {
        VxTransform transform;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        Vec3 pos = Vec3Argument.m_120844_(context, (String)"pos");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (physicsWorld == null) {
            source.m_81352_((Component)Component.m_237113_((String)"The physics system for this dimension is not initialized."));
            return 0;
        }
        VxObjectManager manager = physicsWorld.getObjectManager();
        MarbleRigidBody spawnedMarble = manager.createRigidBody(VxRegisteredObjects.MARBLE, transform = new VxTransform(new RVec3(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()), Quat.sIdentity()), marble -> marble.setRadius(radius));
        if (spawnedMarble != null) {
            source.m_288197_(() -> Component.m_237113_((String)("Successfully spawned a marble with radius " + radius + ".")), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"Failed to spawn the marble. Check the server logs."));
        return 0;
    }
}

