/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item;

import com.github.stephengold.joltjni.MutableCompoundShapeSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.block.BlockRigidBody;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.util.VxVoxelShapeUtil;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class PhysicsCreatorItem
extends Item {
    public PhysicsCreatorItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState originalState = level.m_8055_(pos);
        if (originalState.m_60795_()) return InteractionResult.FAIL;
        if (originalState.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return InteractionResult.FAIL;
        }
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (physicsWorld == null) {
            VxMainClass.LOGGER.error("Could not find VxPhysicsWorld for the level!");
            return InteractionResult.FAIL;
        }
        VxObjectManager objectManager = physicsWorld.getObjectManager();
        try (MutableCompoundShapeSettings ignored = VxVoxelShapeUtil.toMutableCompoundShape(originalState.m_60771_((BlockGetter)level, pos, CollisionContext.m_82749_()));){
            if (ignored == null) {
                VxMainClass.LOGGER.warn("Could not generate a valid physics shape for the block: {}", (Object)originalState);
                InteractionResult interactionResult = InteractionResult.FAIL;
                return interactionResult;
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Error during pre-check of physics shape creation", (Throwable)e);
            return InteractionResult.FAIL;
        }
        try {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            RVec3 position = new RVec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            Quat rotation = Quat.sIdentity();
            VxTransform transform = new VxTransform(position, rotation);
            BlockRigidBody body = objectManager.createRigidBody(VxRegisteredObjects.BLOCK, transform, b -> b.setRepresentedBlockState(originalState));
            if (body != null) return InteractionResult.SUCCESS;
            throw new IllegalStateException("Body creation returned null.");
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Error creating physics object, restoring original block.", (Throwable)e);
            level.m_7731_(pos, originalState, 11);
            return InteractionResult.FAIL;
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

