/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.boxthrower;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.builtin.VxRegisteredObjects;
import net.xmx.velthoric.builtin.box.BoxColor;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class BoxThrowerManager {
    private static final BoxThrowerManager INSTANCE = new BoxThrowerManager();
    private final Map<UUID, Boolean> shootingPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private static final int BOXES_PER_TICK = 5;
    private static final float SHOOT_SPEED = 40.0f;
    private static final float SPAWN_OFFSET = 1.5f;
    private static final float MIN_BOX_SIZE = 0.4f;
    private static final float MAX_BOX_SIZE = 1.2f;

    private BoxThrowerManager() {
    }

    public static BoxThrowerManager getInstance() {
        return INSTANCE;
    }

    public void startShooting(ServerPlayer player) {
        this.shootingPlayers.put(player.m_20148_(), true);
    }

    public void stopShooting(ServerPlayer player) {
        this.shootingPlayers.remove(player.m_20148_());
    }

    public boolean isShooting(ServerPlayer player) {
        return this.shootingPlayers.getOrDefault(player.m_20148_(), false);
    }

    public void serverTick(ServerPlayer player) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.m_9236_().m_46472_());
        if (physicsWorld == null || !physicsWorld.isRunning()) {
            this.stopShooting(player);
            return;
        }
        physicsWorld.execute(() -> {
            for (int i = 0; i < 5; ++i) {
                this.spawnAndLaunchSingleBox(player, physicsWorld);
            }
        });
    }

    private void spawnAndLaunchSingleBox(ServerPlayer player, VxPhysicsWorld physicsWorld) {
        net.minecraft.world.phys.Vec3 eyePos = player.m_146892_();
        net.minecraft.world.phys.Vec3 lookVec = player.m_20154_();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        net.minecraft.world.phys.Vec3 spawnPosMc = eyePos.m_82549_(lookVec.m_82490_(1.5));
        VxTransform transform = new VxTransform(new RVec3((float)spawnPosMc.f_82479_, (float)spawnPosMc.f_82480_, (float)spawnPosMc.f_82481_), Quat.sIdentity());
        float randomWidth = random.nextFloat(0.4f, 1.2f);
        float randomHeight = random.nextFloat(0.4f, 1.2f);
        float randomDepth = random.nextFloat(0.4f, 1.2f);
        Vec3 halfExtents = new Vec3(randomWidth / 2.0f, randomHeight / 2.0f, randomDepth / 2.0f);
        Vec3 launchVelocity = new Vec3((float)lookVec.f_82479_, (float)lookVec.f_82480_, (float)lookVec.f_82481_);
        launchVelocity.scaleInPlace(40.0f);
        VxObjectManager manager = physicsWorld.getObjectManager();
        BoxRigidBody spawnedObject = manager.createRigidBody(VxRegisteredObjects.BOX, transform, box -> {
            box.setHalfExtents(halfExtents);
            box.setColor(BoxColor.getRandom());
        });
        if (spawnedObject != null) {
            int bodyId = spawnedObject.getBodyId();
            BodyInterface bodyInterface = physicsWorld.getPhysicsSystem().getBodyInterface();
            bodyInterface.activateBody(bodyId);
            bodyInterface.setLinearVelocity(bodyId, launchVelocity);
        }
    }
}

