/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.boxthrower.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.xmx.velthoric.item.boxthrower.BoxThrowerManager;

public class BoxThrowerActionPacket {
    private final ActionType actionType;

    public BoxThrowerActionPacket(ActionType actionType) {
        this.actionType = actionType;
    }

    public static void encode(BoxThrowerActionPacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.actionType);
    }

    public static BoxThrowerActionPacket decode(FriendlyByteBuf buf) {
        return new BoxThrowerActionPacket((ActionType)buf.m_130066_(ActionType.class));
    }

    public static void handle(BoxThrowerActionPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            BoxThrowerManager manager = BoxThrowerManager.getInstance();
            switch (msg.actionType) {
                case START_SHOOTING: {
                    manager.startShooting(player);
                    break;
                }
                case STOP_SHOOTING: {
                    manager.stopShooting(player);
                }
            }
        });
    }

    public static enum ActionType {
        START_SHOOTING,
        STOP_SHOOTING;

    }
}

