/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.magnetizer;

import com.github.stephengold.joltjni.AllHitCollideShapeBodyCollector;
import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockWrite;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseQuery;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxRaytracing;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class MagnetizerManager {
    private static final MagnetizerManager INSTANCE = new MagnetizerManager();
    private final Map<UUID, MagnetMode> playerModes = new ConcurrentHashMap<UUID, MagnetMode>();
    private static final float MAGNET_RADIUS = 100.0f;
    private static final float TARGET_DISTANCE = 100.0f;
    private static final float BASE_ATTRACT_FORCE = 2000.0f;
    private static final float BASE_REPEL_FORCE = 3000.0f;

    private MagnetizerManager() {
    }

    public static MagnetizerManager getInstance() {
        return INSTANCE;
    }

    public void startAttract(ServerPlayer player) {
        this.playerModes.put(player.m_20148_(), MagnetMode.ATTRACT);
    }

    public void startRepel(ServerPlayer player) {
        this.playerModes.put(player.m_20148_(), MagnetMode.REPEL);
    }

    public void stop(ServerPlayer player) {
        this.playerModes.put(player.m_20148_(), MagnetMode.INACTIVE);
    }

    public boolean isActing(ServerPlayer player) {
        return this.playerModes.getOrDefault(player.m_20148_(), MagnetMode.INACTIVE) != MagnetMode.INACTIVE;
    }

    public void serverTick(ServerPlayer player) {
        net.minecraft.world.phys.Vec3 lookVec;
        net.minecraft.world.phys.Vec3 rayEnd;
        MagnetMode mode = this.playerModes.getOrDefault(player.m_20148_(), MagnetMode.INACTIVE);
        if (mode == MagnetMode.INACTIVE) {
            return;
        }
        Level level = player.m_9236_();
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (physicsWorld == null || !physicsWorld.isRunning()) {
            this.stop(player);
            return;
        }
        net.minecraft.world.phys.Vec3 eyePos = player.m_146892_();
        VxClipContext context = new VxClipContext(eyePos, rayEnd = eyePos.m_82549_((lookVec = player.m_20154_()).m_82490_(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player, true);
        Optional<VxHitResult> hitResult = VxRaytracing.raycast(level, context);
        net.minecraft.world.phys.Vec3 targetPoint = hitResult.isPresent() ? hitResult.get().m_82450_() : rayEnd;
        RVec3 targetPointRVec = new RVec3((float)targetPoint.m_7096_(), (float)targetPoint.m_7098_(), (float)targetPoint.m_7094_());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SimpleParticleType particleType = mode == MagnetMode.ATTRACT ? ParticleTypes.f_123810_ : ParticleTypes.f_123744_;
            serverLevel.m_8624_(player, (ParticleOptions)particleType, true, (double)targetPointRVec.x(), (double)targetPointRVec.y(), (double)targetPointRVec.z(), 5, 0.1, 0.1, 0.1, 0.0);
        }
        physicsWorld.execute(() -> {
            int[] hitBodyIds;
            PhysicsSystem physicsSystem = physicsWorld.getPhysicsSystem();
            if (physicsSystem == null) {
                return;
            }
            ConstBroadPhaseQuery broadPhaseQuery = physicsSystem.getBroadPhaseQuery();
            AllHitCollideShapeBodyCollector collector = new AllHitCollideShapeBodyCollector();
            BroadPhaseLayerFilter broadPhaseFilter = new BroadPhaseLayerFilter();
            ObjectLayerFilter objectFilter = new ObjectLayerFilter();
            broadPhaseQuery.collideSphere(targetPointRVec.toVec3(), 100.0f, collector, broadPhaseFilter, objectFilter);
            for (int bodyId : hitBodyIds = collector.getHits()) {
                physicsWorld.getBodyInterface().activateBody(bodyId);
                try (BodyLockWrite lock = new BodyLockWrite(physicsSystem.getBodyLockInterface(), bodyId);){
                    Body body;
                    RVec3 bodyPos;
                    RVec3 vectorToBody;
                    double distance;
                    if (!lock.succeededAndIsInBroadPhase() || !lock.getBody().isDynamic() || (distance = (vectorToBody = Op.minus((RVec3Arg)(bodyPos = (body = lock.getBody()).getCenterOfMassPosition()), targetPointRVec)).length()) < 1.0E-5) continue;
                    float forceMagnitude = (float)((double)(mode == MagnetMode.ATTRACT ? 2000.0f : 3000.0f) * distance);
                    Vec3 forceDirection = vectorToBody.toVec3().normalized();
                    if (mode == MagnetMode.ATTRACT) {
                        forceDirection.scaleInPlace(-1.0f);
                    }
                    Vec3 finalForce = Op.star((Vec3Arg)forceDirection, forceMagnitude);
                    body.addForce(finalForce);
                }
            }
            collector.close();
        });
    }

    private static enum MagnetMode {
        INACTIVE,
        ATTRACT,
        REPEL;

    }
}

