/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.magnetizer.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.xmx.velthoric.item.magnetizer.MagnetizerManager;

public class MagnetizerActionPacket {
    private final ActionType actionType;

    public MagnetizerActionPacket(ActionType actionType) {
        this.actionType = actionType;
    }

    public static void encode(MagnetizerActionPacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.actionType);
    }

    public static MagnetizerActionPacket decode(FriendlyByteBuf buf) {
        return new MagnetizerActionPacket((ActionType)buf.m_130066_(ActionType.class));
    }

    public static void handle(MagnetizerActionPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            MagnetizerManager manager = MagnetizerManager.getInstance();
            switch (msg.actionType) {
                case START_ATTRACT: {
                    manager.startAttract(player);
                    break;
                }
                case START_REPEL: {
                    manager.startRepel(player);
                    break;
                }
                case STOP_ACTION: {
                    manager.stop(player);
                }
            }
        });
    }

    public static enum ActionType {
        START_ATTRACT,
        START_REPEL,
        STOP_ACTION;

    }
}

