/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.beam;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.xmx.velthoric.event.api.VxRenderEvent;
import net.xmx.velthoric.item.physicsgun.manager.PhysicsGunClientManager;
import net.xmx.velthoric.physics.object.client.VxClientObjectDataStore;
import net.xmx.velthoric.physics.object.client.VxClientObjectInterpolator;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PhysicsGunBeamRenderer {
    private static final int BEAM_SEGMENTS = 20;
    private static final float BEAM_WIDTH = 0.15f;
    private static final float BEAM_CURVE_STRENGTH = 0.3f;
    private static final float BEAM_MAX_LENGTH = 100.0f;
    private static final RVec3 INTERPOLATED_POSITION = new RVec3();
    private static final Quat INTERPOLATED_ROTATION = new Quat();

    public static void registerEvents() {
        VxRenderEvent.ClientRenderLevelStageEvent.EVENT.register(PhysicsGunBeamRenderer::onRenderLevelStage);
    }

    public static void onRenderLevelStage(VxRenderEvent.ClientRenderLevelStageEvent event) {
        if (event.getStage() != VxRenderEvent.ClientRenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        if (localPlayer == null || mc.f_91073_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        PhysicsGunClientManager clientManager = PhysicsGunClientManager.getInstance();
        VxClientObjectManager objectManager = VxClientObjectManager.getInstance();
        VxClientObjectDataStore store = objectManager.getStore();
        VxClientObjectInterpolator interpolator = objectManager.getInterpolator();
        Camera camera = mc.f_91063_.m_109153_();
        net.minecraft.world.phys.Vec3 camPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        Map<UUID, PhysicsGunClientManager.ClientGrabData> activeGrabs = clientManager.getActiveGrabs();
        for (Map.Entry<UUID, PhysicsGunClientManager.ClientGrabData> entry : activeGrabs.entrySet()) {
            Integer index;
            UUID playerUuid = entry.getKey();
            PhysicsGunClientManager.ClientGrabData grabData = entry.getValue();
            UUID objectUuid = grabData.objectUuid();
            Player player = mc.f_91073_.m_46003_(playerUuid);
            if (player == null || (index = store.getIndexForId(objectUuid)) == null || !store.render_isInitialized[index] || store.objectType[index] != EBodyType.RigidBody) continue;
            interpolator.interpolateFrame(store, index, partialTicks, INTERPOLATED_POSITION, INTERPOLATED_ROTATION);
            net.minecraft.world.phys.Vec3 startPoint = PhysicsGunBeamRenderer.getGunTipPosition(player, partialTicks);
            RVec3 centerPos = INTERPOLATED_POSITION;
            Quat rotation = INTERPOLATED_ROTATION;
            net.minecraft.world.phys.Vec3 localHitPoint = grabData.localHitPoint();
            Vec3 localHitJolt = new Vec3((float)localHitPoint.m_7096_(), (float)localHitPoint.m_7098_(), (float)localHitPoint.m_7094_());
            Vec3 rotatedOffset = Op.star((QuatArg)rotation, (Vec3Arg)localHitJolt);
            RVec3 endPointJolt = Op.plus((RVec3Arg)centerPos, (Vec3Arg)rotatedOffset);
            net.minecraft.world.phys.Vec3 endPoint = new net.minecraft.world.phys.Vec3(endPointJolt.xx(), endPointJolt.yy(), endPointJolt.zz());
            net.minecraft.world.phys.Vec3 playerLookVec = PhysicsGunBeamRenderer.getPlayerLookVector(player, partialTicks);
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            PhysicsGunBeamRenderer.drawThickCurvedBeam(bufferBuilder, matrix, camPos, startPoint, endPoint, playerLookVec);
            tesselator.m_85914_();
        }
        Set<UUID> playersTryingToGrab = clientManager.getPlayersTryingToGrab();
        for (UUID playerUuid : playersTryingToGrab) {
            net.minecraft.world.phys.Vec3 traceEnd;
            ClipContext clipContext;
            BlockHitResult blockHitResult;
            Player player;
            if (activeGrabs.containsKey(playerUuid) || (player = mc.f_91073_.m_46003_(playerUuid)) == null) continue;
            net.minecraft.world.phys.Vec3 startPoint = PhysicsGunBeamRenderer.getGunTipPosition(player, partialTicks);
            net.minecraft.world.phys.Vec3 playerLookVec = PhysicsGunBeamRenderer.getPlayerLookVector(player, partialTicks);
            net.minecraft.world.phys.Vec3 traceStart = player.m_20299_(partialTicks);
            Optional<net.minecraft.world.phys.Vec3> physicsHitPoint = PhysicsGunBeamRenderer.raycastClientPhysicsObjects(traceStart, playerLookVec, 100.0f, store, interpolator, partialTicks);
            net.minecraft.world.phys.Vec3 endPoint = physicsHitPoint.isPresent() ? physicsHitPoint.get() : ((blockHitResult = mc.f_91073_.m_45547_(clipContext = new ClipContext(traceStart, traceEnd = traceStart.m_82549_(playerLookVec.m_82490_(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() == HitResult.Type.MISS ? traceEnd : blockHitResult.m_82450_());
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            PhysicsGunBeamRenderer.drawThickCurvedBeam(bufferBuilder, matrix, camPos, startPoint, endPoint, playerLookVec);
            tesselator.m_85914_();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static Optional<net.minecraft.world.phys.Vec3> raycastClientPhysicsObjects(net.minecraft.world.phys.Vec3 rayOrigin, net.minecraft.world.phys.Vec3 rayDirection, float maxDistance, VxClientObjectDataStore store, VxClientObjectInterpolator interpolator, float partialTicks) {
        double closestHitDist = maxDistance;
        net.minecraft.world.phys.Vec3 hitPoint = null;
        double OBJECT_RADIUS = 1.5;
        double OBJECT_RADIUS_SQR = 2.25;
        RVec3 tempPos = new RVec3();
        Quat tempRot = new Quat();
        for (UUID id : store.getAllObjectIds()) {
            double t_hit;
            double d2;
            Integer i = store.getIndexForId(id);
            if (i == null || !store.render_isInitialized[i]) continue;
            interpolator.interpolateFrame(store, i, partialTicks, tempPos, tempRot);
            net.minecraft.world.phys.Vec3 objectCenter = new net.minecraft.world.phys.Vec3(tempPos.xx(), tempPos.yy(), tempPos.zz());
            net.minecraft.world.phys.Vec3 originToCenter = objectCenter.m_82546_(rayOrigin);
            double t = originToCenter.m_82526_(rayDirection);
            if (t < 0.0 || t > closestHitDist || !((d2 = originToCenter.m_82556_() - t * t) < 2.25) || !((t_hit = t - Math.sqrt(2.25 - d2)) < closestHitDist) || !(t_hit >= 0.0)) continue;
            closestHitDist = t_hit;
            hitPoint = rayOrigin.m_82549_(rayDirection.m_82490_(closestHitDist));
        }
        return Optional.ofNullable(hitPoint);
    }

    private static void drawThickCurvedBeam(BufferBuilder bufferBuilder, Matrix4f matrix, net.minecraft.world.phys.Vec3 camPos, net.minecraft.world.phys.Vec3 start, net.minecraft.world.phys.Vec3 end, net.minecraft.world.phys.Vec3 playerLookVec) {
        float r = 0.9725f;
        float g = 0.2863f;
        float b = 0.0117f;
        float baseAlpha = 0.83f;
        double distance = start.m_82554_(end);
        net.minecraft.world.phys.Vec3 p0 = start;
        net.minecraft.world.phys.Vec3 p3 = end;
        net.minecraft.world.phys.Vec3 p1 = p0.m_82549_(playerLookVec.m_82490_(distance * (double)0.3f));
        net.minecraft.world.phys.Vec3 tangentAtEnd = p0.m_82546_(p3).m_82541_();
        net.minecraft.world.phys.Vec3 p2 = p3.m_82549_(tangentAtEnd.m_82490_(distance * (double)0.3f));
        net.minecraft.world.phys.Vec3 lastPos = p0;
        for (int i = 0; i <= 20; ++i) {
            net.minecraft.world.phys.Vec3 segmentDir;
            float t = (float)i / 20.0f;
            net.minecraft.world.phys.Vec3 currentPos = PhysicsGunBeamRenderer.getCubicBezierPoint(t, p0, p1, p2, p3);
            net.minecraft.world.phys.Vec3 viewDir = currentPos.m_82546_(camPos).m_82541_();
            net.minecraft.world.phys.Vec3 vec3 = segmentDir = i == 0 ? p1.m_82546_(p0).m_82541_() : currentPos.m_82546_(lastPos).m_82541_();
            if (segmentDir.m_82556_() < 1.0E-6) {
                segmentDir = playerLookVec;
            }
            net.minecraft.world.phys.Vec3 side = segmentDir.m_82537_(viewDir).m_82541_().m_82490_((double)0.075f);
            bufferBuilder.m_252986_(matrix, (float)(currentPos.f_82479_ + side.f_82479_), (float)(currentPos.f_82480_ + side.f_82480_), (float)(currentPos.f_82481_ + side.f_82481_)).m_85950_(r, g, b, baseAlpha).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)(currentPos.f_82479_ - side.f_82479_), (float)(currentPos.f_82480_ - side.f_82480_), (float)(currentPos.f_82481_ - side.f_82481_)).m_85950_(r, g, b, baseAlpha).m_5752_();
            lastPos = currentPos;
        }
    }

    private static net.minecraft.world.phys.Vec3 getCubicBezierPoint(float t, net.minecraft.world.phys.Vec3 p0, net.minecraft.world.phys.Vec3 p1, net.minecraft.world.phys.Vec3 p2, net.minecraft.world.phys.Vec3 p3) {
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * t;
        net.minecraft.world.phys.Vec3 p = p0.m_82490_((double)uuu);
        p = p.m_82549_(p1.m_82490_((double)(3.0f * uu * t)));
        p = p.m_82549_(p2.m_82490_((double)(3.0f * u * tt)));
        p = p.m_82549_(p3.m_82490_((double)ttt));
        return p;
    }

    private static net.minecraft.world.phys.Vec3 getPlayerLookVector(Player player, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (player.m_7306_((Entity)mc.f_91074_) && mc.f_91066_.m_92176_().m_90612_()) {
            Camera camera = mc.f_91063_.m_109153_();
            Vector3f lookVector = camera.m_253058_();
            return new net.minecraft.world.phys.Vec3((double)lookVector.x(), (double)lookVector.y(), (double)lookVector.z());
        }
        return player.m_20252_(partialTicks);
    }

    private static net.minecraft.world.phys.Vec3 getGunTipPosition(Player player, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (player.m_7306_((Entity)mc.f_91074_) && mc.f_91066_.m_92176_().m_90612_()) {
            Camera camera = mc.f_91063_.m_109153_();
            Vector3f lookVector = camera.m_253058_();
            net.minecraft.world.phys.Vec3 camForward = new net.minecraft.world.phys.Vec3((double)lookVector.x(), (double)lookVector.y(), (double)lookVector.z());
            Vector3f upVector = camera.m_253028_();
            net.minecraft.world.phys.Vec3 camUp = new net.minecraft.world.phys.Vec3((double)upVector.x(), (double)upVector.y(), (double)upVector.z());
            net.minecraft.world.phys.Vec3 camRight = camForward.m_82537_(camUp).m_82541_();
            return camera.m_90583_().m_82549_(camForward.m_82490_(0.5)).m_82549_(camRight.m_82490_(0.3)).m_82549_(camUp.m_82490_(-0.15));
        }
        net.minecraft.world.phys.Vec3 eyePos = player.m_20299_(partialTicks);
        net.minecraft.world.phys.Vec3 lookVec = player.m_20252_(partialTicks);
        net.minecraft.world.phys.Vec3 upVec = player.m_20289_(partialTicks);
        net.minecraft.world.phys.Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_();
        return eyePos.m_82549_(lookVec.m_82490_(0.3)).m_82549_(rightVec.m_82490_(-0.35)).m_82549_(upVec.m_82490_(-0.3));
    }
}

