/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.manager;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.BodyLockWrite;
import com.github.stephengold.joltjni.MotionProperties;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterfaceLocking;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.item.physicsgun.GrabbedObjectInfo;
import net.xmx.velthoric.item.physicsgun.manager.PhysicsGunClientManager;
import net.xmx.velthoric.item.physicsgun.packet.PhysicsGunSyncPacket;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxRaytracing;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class PhysicsGunServerManager {
    private static final PhysicsGunServerManager INSTANCE = new PhysicsGunServerManager();
    private final Map<UUID, GrabbedObjectInfo> grabbedObjects = new ConcurrentHashMap<UUID, GrabbedObjectInfo>();
    private final Set<UUID> playersTryingToGrab = ConcurrentHashMap.newKeySet();
    private static final float MIN_DISTANCE = 2.0f;
    private static final float MAX_DISTANCE = 450.0f;

    private PhysicsGunServerManager() {
    }

    public static PhysicsGunServerManager getInstance() {
        return INSTANCE;
    }

    private static Quat playerRotToQuat(float pitch, float yaw) {
        Quat qPitch = Quat.sRotation(new Vec3(1.0f, 0.0f, 0.0f), (float)Math.toRadians(pitch));
        Quat qYaw = Quat.sRotation(new Vec3(0.0f, 1.0f, 0.0f), (float)Math.toRadians(-yaw));
        return Op.star((QuatArg)qYaw, (QuatArg)qPitch);
    }

    public void startGrabAttempt(ServerPlayer player) {
        if (this.isGrabbing((Player)player)) {
            return;
        }
        if (this.playersTryingToGrab.add(player.m_20148_())) {
            this.syncStateWithClients();
        }
    }

    public void stopGrabAttempt(ServerPlayer player) {
        boolean changed = this.playersTryingToGrab.remove(player.m_20148_());
        if (this.isGrabbing((Player)player)) {
            this.stopGrab(player);
        } else if (changed) {
            this.syncStateWithClients();
        }
    }

    public boolean isGrabbing(Player player) {
        return this.grabbedObjects.containsKey(player.m_20148_());
    }

    public Map<UUID, GrabbedObjectInfo> getGrabbedObjects() {
        return this.grabbedObjects;
    }

    public boolean isTryingToGrab(Player player) {
        return this.playersTryingToGrab.contains(player.m_20148_());
    }

    public Set<UUID> getPlayersTryingToGrab() {
        return this.playersTryingToGrab;
    }

    public void startRotationMode(ServerPlayer player) {
        this.grabbedObjects.computeIfPresent(player.m_20148_(), (uuid, info) -> {
            Quat currentPlayerRotation = PhysicsGunServerManager.playerRotToQuat(player.m_146909_(), player.m_146908_());
            Quat playerRotationDelta = Op.star((QuatArg)currentPlayerRotation, (QuatArg)info.initialPlayerRotation().conjugated());
            Quat syncedBodyRotation = Op.star((QuatArg)playerRotationDelta, (QuatArg)info.initialBodyRotation());
            return new GrabbedObjectInfo(info.objectId(), info.bodyId(), info.grabPointLocal(), info.currentDistance(), info.originalAngularDamping(), syncedBodyRotation, currentPlayerRotation, true);
        });
    }

    public void stopRotationMode(ServerPlayer player) {
        this.grabbedObjects.computeIfPresent(player.m_20148_(), (uuid, info) -> new GrabbedObjectInfo(info.objectId(), info.bodyId(), info.grabPointLocal(), info.currentDistance(), info.originalAngularDamping(), info.initialBodyRotation(), PhysicsGunServerManager.playerRotToQuat(player.m_146909_(), player.m_146908_()), false));
    }

    public void startGrab(ServerPlayer player) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.m_9236_().m_46472_());
        if (physicsWorld == null) {
            return;
        }
        net.minecraft.world.phys.Vec3 eyePos = player.m_146892_();
        net.minecraft.world.phys.Vec3 lookVec = player.m_20154_();
        Level level = player.m_9236_();
        physicsWorld.execute(() -> {
            RVec3 rayOrigin = new RVec3((float)eyePos.m_7096_(), (float)eyePos.m_7098_(), (float)eyePos.m_7094_());
            Vec3 rayDirection = new Vec3((float)lookVec.m_7096_(), (float)lookVec.m_7098_(), (float)lookVec.m_7094_());
            VxRaytracing.raycastPhysics(level, rayOrigin, rayDirection, 450.0f).ifPresent(physicsHitResult -> {
                block16: {
                    VxHitResult.PhysicsHit physicsHit = physicsHitResult.getPhysicsHit().orElseThrow();
                    VxBody physicsObject = physicsWorld.getObjectManager().getByBodyId(physicsHit.bodyId());
                    if (physicsObject == null) {
                        return;
                    }
                    UUID objectId = physicsObject.getPhysicsId();
                    BodyInterface bodyInterface = physicsWorld.getBodyInterface();
                    if (bodyInterface == null) {
                        return;
                    }
                    bodyInterface.setMotionType(physicsHit.bodyId(), EMotionType.Dynamic, EActivation.Activate);
                    bodyInterface.activateBody(physicsHit.bodyId());
                    ConstBodyLockInterfaceLocking bodyLockInterface = physicsWorld.getBodyLockInterface();
                    if (bodyLockInterface == null) {
                        return;
                    }
                    try (BodyLockWrite lock = new BodyLockWrite(bodyLockInterface, physicsHit.bodyId());){
                        if (!lock.succeededAndIsInBroadPhase() || !lock.getBody().isDynamic()) break block16;
                        Body body = lock.getBody();
                        MotionProperties motionProperties = body.getMotionProperties();
                        if (motionProperties == null) {
                            return;
                        }
                        Vec3 offset = Op.star((Vec3Arg)rayDirection, physicsHit.hitFraction() * 450.0f);
                        RVec3 hitPointWorld = Op.plus((RVec3Arg)rayOrigin, (Vec3Arg)offset);
                        try (RMat44 invBodyTransform = body.getInverseCenterOfMassTransform();){
                            float originalDamping = motionProperties.getAngularDamping();
                            Vec3 hitPointLocal = Op.star((RMat44Arg)invBodyTransform, (RVec3Arg)hitPointWorld).toVec3();
                            float grabDistance = (float)Op.minus((RVec3Arg)rayOrigin, hitPointWorld).length();
                            Quat initialPlayerRot = PhysicsGunServerManager.playerRotToQuat(player.m_146909_(), player.m_146908_());
                            Quat initialBodyRot = body.getRotation();
                            GrabbedObjectInfo info = new GrabbedObjectInfo(objectId, physicsHit.bodyId(), hitPointLocal, grabDistance, originalDamping, initialBodyRot, initialPlayerRot, false);
                            this.grabbedObjects.put(player.m_20148_(), info);
                            this.playersTryingToGrab.remove(player.m_20148_());
                            motionProperties.setAngularDamping(2.0f);
                            body.setAngularVelocity(new Vec3(0.0f, 0.0f, 0.0f));
                            this.syncStateWithClients();
                        }
                    }
                }
            });
        });
    }

    public void stopGrab(ServerPlayer player) {
        GrabbedObjectInfo info = this.grabbedObjects.remove(player.m_20148_());
        if (info != null) {
            this.syncStateWithClients();
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.m_9236_().m_46472_());
            if (physicsWorld != null) {
                physicsWorld.execute(() -> {
                    BodyInterface bodyInterface = physicsWorld.getBodyInterface();
                    ConstBodyLockInterfaceLocking bodyLockInterface = physicsWorld.getBodyLockInterface();
                    if (bodyInterface != null && bodyLockInterface != null) {
                        try (BodyLockWrite lock = new BodyLockWrite(bodyLockInterface, info.bodyId());){
                            MotionProperties motionProperties;
                            if (lock.succeededAndIsInBroadPhase() && (motionProperties = lock.getBody().getMotionProperties()) != null) {
                                motionProperties.setAngularDamping(info.originalAngularDamping());
                            }
                        }
                        bodyInterface.activateBody(info.bodyId());
                    }
                });
            }
        }
    }

    public void freezeObject(ServerPlayer player) {
        GrabbedObjectInfo info = this.grabbedObjects.get(player.m_20148_());
        if (info == null) {
            return;
        }
        this.stopGrab(player);
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.m_9236_().m_46472_());
        if (physicsWorld == null) {
            return;
        }
        physicsWorld.execute(() -> {
            BodyInterface bodyInterface = physicsWorld.getBodyInterface();
            if (bodyInterface != null) {
                bodyInterface.setMotionType(info.bodyId(), EMotionType.Static, EActivation.DontActivate);
            }
        });
    }

    public void updateScroll(ServerPlayer player, float scrollDelta) {
        this.grabbedObjects.computeIfPresent(player.m_20148_(), (uuid, info) -> {
            float newDistance = info.currentDistance() + scrollDelta;
            newDistance = Math.max(2.0f, Math.min(450.0f, newDistance));
            return new GrabbedObjectInfo(info.objectId(), info.bodyId(), info.grabPointLocal(), newDistance, info.originalAngularDamping(), info.initialBodyRotation(), info.initialPlayerRotation(), info.inRotationMode());
        });
    }

    public void updateRotation(ServerPlayer player, float deltaX, float deltaY) {
        this.grabbedObjects.computeIfPresent(player.m_20148_(), (uuid, info) -> {
            net.minecraft.world.phys.Vec3 worldUp;
            float SENSITIVITY = 0.003f;
            net.minecraft.world.phys.Vec3 look = player.m_20154_();
            net.minecraft.world.phys.Vec3 right = look.m_82537_(worldUp = new net.minecraft.world.phys.Vec3(0.0, 1.0, 0.0)).m_82541_();
            if (right.m_82556_() < 1.0E-7) {
                float yawRad = (float)Math.toRadians(player.m_146908_());
                right = new net.minecraft.world.phys.Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            }
            Vec3 joltUp = new Vec3(0.0f, 1.0f, 0.0f);
            Vec3 joltRight = new Vec3((float)right.f_82479_, (float)right.f_82480_, (float)right.f_82481_);
            Quat rotYaw = Quat.sRotation(joltUp, deltaX * 0.003f);
            Quat rotPitch = Quat.sRotation(joltRight, deltaY * 0.003f);
            Quat manualRot = Op.star((QuatArg)rotYaw, (QuatArg)rotPitch);
            Quat newInitialBodyRotation = Op.star((QuatArg)manualRot, (QuatArg)info.initialBodyRotation());
            return new GrabbedObjectInfo(info.objectId(), info.bodyId(), info.grabPointLocal(), info.currentDistance(), info.originalAngularDamping(), newInitialBodyRotation, info.initialPlayerRotation(), info.inRotationMode());
        });
    }

    public void serverTick(ServerPlayer player) {
        GrabbedObjectInfo info = this.grabbedObjects.get(player.m_20148_());
        if (info == null) {
            return;
        }
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.m_9236_().m_46472_());
        if (physicsWorld == null) {
            this.stopGrab(player);
            return;
        }
        net.minecraft.world.phys.Vec3 eyePos = player.m_146892_();
        net.minecraft.world.phys.Vec3 lookVec = player.m_20154_();
        float P_GAIN_LINEAR = 250.0f;
        float D_GAIN_LINEAR = 25.0f;
        float P_GAIN_ANGULAR = 150.0f;
        float D_GAIN_ANGULAR = 15.0f;
        physicsWorld.execute(() -> {
            BodyInterface bodyInterface = physicsWorld.getBodyInterface();
            if (bodyInterface == null || !bodyInterface.isAdded(info.bodyId())) {
                return;
            }
            bodyInterface.activateBody(info.bodyId());
            ConstBodyLockInterfaceLocking bodyLockInterface = physicsWorld.getBodyLockInterface();
            if (bodyLockInterface == null) {
                return;
            }
            try (BodyLockWrite lock = new BodyLockWrite(bodyLockInterface, info.bodyId());){
                Quat targetBodyRotation;
                if (!lock.succeededAndIsInBroadPhase() || !lock.getBody().isDynamic()) {
                    this.grabbedObjects.remove(player.m_20148_());
                    this.syncStateWithClients();
                    return;
                }
                Body body = lock.getBody();
                MotionProperties motionProperties = body.getMotionProperties();
                if (motionProperties == null || motionProperties.getInverseMass() == 0.0f) {
                    return;
                }
                float mass = 1.0f / motionProperties.getInverseMass();
                try (RMat44 comTransform = body.getCenterOfMassTransform();){
                    RVec3 targetPointWorld = new RVec3(eyePos.f_82479_ + lookVec.f_82479_ * (double)info.currentDistance(), eyePos.f_82480_ + lookVec.f_82480_ * (double)info.currentDistance(), eyePos.f_82481_ + lookVec.f_82481_ * (double)info.currentDistance());
                    RVec3 currentGrabPointWorld = Op.star((RMat44Arg)comTransform, (Vec3Arg)info.grabPointLocal());
                    RVec3 positionError = Op.minus((RVec3Arg)targetPointWorld, currentGrabPointWorld);
                    Vec3 currentVelocity = body.getLinearVelocity();
                    Vec3 desiredAcceleration = Op.minus(Op.star((Vec3Arg)positionError.toVec3(), 250.0f), (Vec3Arg)Op.star((Vec3Arg)currentVelocity, 25.0f));
                    Vec3 force = Op.star((Vec3Arg)desiredAcceleration, mass);
                    body.addForce(force);
                }
                if (info.inRotationMode()) {
                    targetBodyRotation = info.initialBodyRotation();
                } else {
                    Quat currentPlayerRotation = PhysicsGunServerManager.playerRotToQuat(player.m_146909_(), player.m_146908_());
                    Quat playerRotationDelta = Op.star((QuatArg)currentPlayerRotation, (QuatArg)info.initialPlayerRotation().conjugated());
                    targetBodyRotation = Op.star((QuatArg)playerRotationDelta, (QuatArg)info.initialBodyRotation());
                }
                Quat currentBodyRotation = body.getRotation();
                Quat errorQuat = Op.star((QuatArg)targetBodyRotation, (QuatArg)currentBodyRotation.conjugated());
                if (errorQuat.getW() < 0.0f) {
                    errorQuat.set(-errorQuat.getX(), -errorQuat.getY(), -errorQuat.getZ(), -errorQuat.getW());
                }
                Vec3 rotationError = new Vec3(errorQuat.getX(), errorQuat.getY(), errorQuat.getZ());
                Vec3 currentAngularVelocity = body.getAngularVelocity();
                Vec3 desiredAngularAccel = Op.minus(Op.star((Vec3Arg)rotationError, 150.0f), (Vec3Arg)Op.star((Vec3Arg)currentAngularVelocity, 15.0f));
                Quat invBodyRot = currentBodyRotation.conjugated();
                Vec3 desiredAngularAccelLocal = Op.star((QuatArg)invBodyRot, (Vec3Arg)desiredAngularAccel);
                Vec3 invInertiaDiag = motionProperties.getInverseInertiaDiagonal();
                float ix = invInertiaDiag.getX() == 0.0f ? 0.0f : 1.0f / invInertiaDiag.getX();
                float iy = invInertiaDiag.getY() == 0.0f ? 0.0f : 1.0f / invInertiaDiag.getY();
                float iz = invInertiaDiag.getZ() == 0.0f ? 0.0f : 1.0f / invInertiaDiag.getZ();
                Vec3 inertiaDiag = new Vec3(ix, iy, iz);
                Quat inertiaRotation = motionProperties.getInertiaRotation();
                Quat invInertiaRotation = inertiaRotation.conjugated();
                Vec3 accelInInertiaSpace = Op.star((QuatArg)invInertiaRotation, (Vec3Arg)desiredAngularAccelLocal);
                accelInInertiaSpace.setX(accelInInertiaSpace.getX() * inertiaDiag.getX());
                accelInInertiaSpace.setY(accelInInertiaSpace.getY() * inertiaDiag.getY());
                accelInInertiaSpace.setZ(accelInInertiaSpace.getZ() * inertiaDiag.getZ());
                Vec3 torqueInInertiaSpace = accelInInertiaSpace;
                Vec3 torqueLocal = Op.star((QuatArg)inertiaRotation, (Vec3Arg)torqueInInertiaSpace);
                Vec3 torqueWorld = Op.star((QuatArg)currentBodyRotation, (Vec3Arg)torqueLocal);
                body.addTorque(torqueWorld);
            }
        });
    }

    public void syncStateWithClients() {
        Map clientGrabData = this.grabbedObjects.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> {
            GrabbedObjectInfo info = (GrabbedObjectInfo)entry.getValue();
            net.minecraft.world.phys.Vec3 localHitPoint = new net.minecraft.world.phys.Vec3((double)info.grabPointLocal().getX(), (double)info.grabPointLocal().getY(), (double)info.grabPointLocal().getZ());
            return new PhysicsGunClientManager.ClientGrabData(info.objectId(), localHitPoint);
        }));
        VxPacketHandler.sendToAll(new PhysicsGunSyncPacket(clientGrabData, this.playersTryingToGrab));
    }

    public void syncStateForNewPlayer(ServerPlayer player) {
        Map clientGrabData = this.grabbedObjects.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> {
            GrabbedObjectInfo info = (GrabbedObjectInfo)entry.getValue();
            net.minecraft.world.phys.Vec3 localHitPoint = new net.minecraft.world.phys.Vec3((double)info.grabPointLocal().getX(), (double)info.grabPointLocal().getY(), (double)info.grabPointLocal().getZ());
            return new PhysicsGunClientManager.ClientGrabData(info.objectId(), localHitPoint);
        }));
        VxPacketHandler.sendToPlayer(new PhysicsGunSyncPacket(clientGrabData, this.playersTryingToGrab), player);
    }
}

