/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.packet;

import dev.architectury.networking.NetworkManager;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.item.physicsgun.manager.PhysicsGunClientManager;

public class PhysicsGunSyncPacket {
    private final Map<UUID, PhysicsGunClientManager.ClientGrabData> activeGrabs;
    private final Set<UUID> playersTryingToGrab;

    public PhysicsGunSyncPacket(Map<UUID, PhysicsGunClientManager.ClientGrabData> activeGrabs, Set<UUID> playersTryingToGrab) {
        this.activeGrabs = activeGrabs;
        this.playersTryingToGrab = playersTryingToGrab;
    }

    public static void encode(PhysicsGunSyncPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.activeGrabs.size());
        for (Map.Entry<UUID, PhysicsGunClientManager.ClientGrabData> entry : msg.activeGrabs.entrySet()) {
            buf.m_130077_(entry.getKey());
            PhysicsGunClientManager.ClientGrabData data = entry.getValue();
            buf.m_130077_(data.objectUuid());
            buf.writeDouble(data.localHitPoint().m_7096_());
            buf.writeDouble(data.localHitPoint().m_7098_());
            buf.writeDouble(data.localHitPoint().m_7094_());
        }
        buf.m_130130_(msg.playersTryingToGrab.size());
        for (UUID uuid : msg.playersTryingToGrab) {
            buf.m_130077_(uuid);
        }
    }

    public static PhysicsGunSyncPacket decode(FriendlyByteBuf buf) {
        int grabsSize = buf.m_130242_();
        ConcurrentHashMap<UUID, PhysicsGunClientManager.ClientGrabData> activeGrabs = new ConcurrentHashMap<UUID, PhysicsGunClientManager.ClientGrabData>();
        for (int i2 = 0; i2 < grabsSize; ++i2) {
            UUID playerUuid = buf.m_130259_();
            UUID objectUuid = buf.m_130259_();
            Vec3 localHitPoint = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            activeGrabs.put(playerUuid, new PhysicsGunClientManager.ClientGrabData(objectUuid, localHitPoint));
        }
        int tryingSize = buf.m_130242_();
        Set<UUID> playersTryingToGrab = IntStream.range(0, tryingSize).mapToObj(i -> buf.m_130259_()).collect(Collectors.toSet());
        return new PhysicsGunSyncPacket(activeGrabs, playersTryingToGrab);
    }

    public static void handle(PhysicsGunSyncPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> PhysicsGunClientManager.getInstance().updateState(msg.activeGrabs, msg.playersTryingToGrab));
    }
}

