/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.event.chunk;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.xmx.velthoric.event.api.VxChunkEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class})
public class ChunkMapMixin_VxChunkLoadEvent {
    @Inject(method={"protoChunkToFullChunk"}, at={@At(value="RETURN")}, cancellable=true)
    private void onProtoChunkToFullChunk(ChunkHolder holder, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        CompletableFuture originalFuture = (CompletableFuture)cir.getReturnValue();
        CompletionStage newFuture = originalFuture.thenApply(either -> {
            either.ifLeft(chunkAccess -> {
                if (chunkAccess instanceof LevelChunk) {
                    LevelChunk levelChunk = (LevelChunk)chunkAccess;
                    ((VxChunkEvent.Load.Listener)VxChunkEvent.Load.EVENT.invoker()).onChunkLoad(new VxChunkEvent.Load(levelChunk));
                }
            });
            return either;
        });
        cir.setReturnValue((Object)newFuture);
    }
}

