/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class})
public abstract class MixinDebugScreenOverlay {
    @Shadow
    @Final
    private Minecraft f_94030_;
    @Shadow
    @Final
    private Font f_94031_;

    @Shadow
    protected abstract int m_94045_(int var1, int var2, int var3, int var4);

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void onRenderEnd(GuiGraphics guiGraphics, CallbackInfo ci) {
        VxPhysicsWorld physicsWorld;
        if (this.f_94030_.f_91066_.f_92065_ && (physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.f_94030_.f_91073_.m_46472_())) != null) {
            int screenWidth = guiGraphics.m_280182_();
            int screenHeight = guiGraphics.m_280206_();
            int graphWidth = Math.min(screenWidth / 2, 240);
            int xPos = screenWidth - graphWidth;
            int baseY = screenHeight - 70;
            this.drawPhysicsTickChart(guiGraphics, physicsWorld.getPhysicsFrameTimer(), xPos, graphWidth, baseY);
        }
    }

    private void drawPhysicsTickChart(GuiGraphics guiGraphics, FrameTimer frameTimer, int x, int width, int baseY) {
        int logStart = frameTimer.m_13754_();
        int logEnd = frameTimer.m_13761_();
        long[] log = frameTimer.m_13764_();
        int dataLength = log.length - Math.max(0, log.length - width);
        int logIndex = frameTimer.m_13762_(logStart + Math.max(0, log.length - width));
        long totalTime = 0L;
        int minTime = Integer.MAX_VALUE;
        int maxTime = Integer.MIN_VALUE;
        for (int i = 0; i < dataLength; ++i) {
            int timeMs = (int)(log[frameTimer.m_13762_(logIndex + i)] / 1000000L);
            minTime = Math.min(minTime, timeMs);
            maxTime = Math.max(maxTime, timeMs);
            totalTime += (long)timeMs;
        }
        guiGraphics.m_285944_(RenderType.m_286086_(), x, baseY - 60, x + dataLength, baseY, -1873784752);
        int currentX = x;
        while (logIndex != logEnd) {
            int scaledHeight = frameTimer.m_13757_(log[logIndex], 30, 60);
            int color = this.m_94045_(Mth.m_14045_((int)scaledHeight, (int)0, (int)60), 0, 30, 60);
            guiGraphics.m_285944_(RenderType.m_286086_(), currentX, baseY - scaledHeight, currentX + 1, baseY, color);
            ++currentX;
            logIndex = frameTimer.m_13762_(logIndex + 1);
        }
        guiGraphics.m_285844_(RenderType.m_286086_(), x, x + dataLength - 1, baseY - 60, -1);
        guiGraphics.m_285844_(RenderType.m_286086_(), x, x + dataLength - 1, baseY - 1, -1);
        guiGraphics.m_285886_(RenderType.m_286086_(), x, baseY - 60, baseY, -1);
        guiGraphics.m_285886_(RenderType.m_286086_(), x + dataLength - 1, baseY - 60, baseY, -1);
        guiGraphics.m_285944_(RenderType.m_286086_(), x + 1, baseY - 60 + 1, x + 40, baseY - 60 + 10, -1873784752);
        guiGraphics.m_280056_(this.f_94031_, "Physics", x + 2, baseY - 60 + 2, 0xE0E0E0, false);
        String minText = minTime + " ms min";
        String avgText = (dataLength > 0 ? totalTime / (long)dataLength : 0L) + " ms avg";
        String maxText = maxTime + " ms max";
        guiGraphics.m_280056_(this.f_94031_, minText, x + 2, baseY - 60 - 9, 0xE0E0E0, false);
        guiGraphics.m_280137_(this.f_94031_, avgText, x + dataLength / 2, baseY - 60 - 9, 0xE0E0E0);
        guiGraphics.m_280488_(this.f_94031_, maxText, x + dataLength - this.f_94031_.m_92895_(maxText), baseY - 60 - 9, 0xE0E0E0);
    }
}

