/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.object;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.object.manager.VxObjectNetworkDispatcher;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMapMixin_DispatchObjectsToPlayers {
    @Shadow
    @Final
    ServerLevel f_140133_;

    @Unique
    private VxObjectNetworkDispatcher velthoric$getDispatcher() {
        VxObjectManager manager;
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)this.f_140133_.m_46472_());
        if (world != null && (manager = world.getObjectManager()) != null) {
            return manager.getNetworkDispatcher();
        }
        return null;
    }

    @Inject(method={"move"}, at={@At(value="TAIL")})
    private void velthoric$onPlayerMove(ServerPlayer player, CallbackInfo ci) {
        VxObjectNetworkDispatcher dispatcher = this.velthoric$getDispatcher();
        if (dispatcher != null) {
            dispatcher.updatePlayerTracking(player);
        }
    }

    @Inject(method={"updatePlayerStatus"}, at={@At(value="TAIL")})
    private void velthoric$onPlayerStatusUpdate(ServerPlayer player, boolean track, CallbackInfo ci) {
        VxObjectNetworkDispatcher dispatcher = this.velthoric$getDispatcher();
        if (dispatcher != null) {
            if (track) {
                dispatcher.onPlayerJoin(player);
            } else {
                dispatcher.onPlayerDisconnect(player);
            }
        }
    }
}

