/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.riding.render;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.xmx.velthoric.physics.object.client.VxClientObjectDataStore;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.riding.VxOriginalState;
import net.xmx.velthoric.physics.riding.VxRidingProxyEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer_SmoothEntityPosition {
    @Shadow
    @Final
    Minecraft f_109059_;
    @Unique
    private final RVec3 velthoric_interpolatedPosition = new RVec3();
    @Unique
    private final Quat velthoric_interpolatedRotation = new Quat();
    @Unique
    private final Map<Integer, VxOriginalState> velthoric_originalStates = new HashMap<Integer, VxOriginalState>();

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.BEFORE)})
    private void velthoric_preRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.clear();
        for (Entity entity : clientWorld.m_104735_()) {
            Entity passenger;
            VxRidingProxyEntity proxy;
            if (!(entity instanceof VxRidingProxyEntity) || (proxy = (VxRidingProxyEntity)entity).m_20197_().isEmpty() || (passenger = proxy.m_146895_()) == null) continue;
            this.velthoric_adjustEntityForRender(proxy, tickDelta);
            this.velthoric_adjustEntityForRender(passenger, tickDelta);
        }
    }

    @Unique
    private void velthoric_adjustEntityForRender(Entity entity, float tickDelta) {
        VxRidingProxyEntity proxy;
        Entity vehicle = entity.m_20202_();
        if (vehicle instanceof VxRidingProxyEntity) {
            VxRidingProxyEntity vehicleProxy;
            proxy = vehicleProxy = (VxRidingProxyEntity)vehicle;
        } else if (entity instanceof VxRidingProxyEntity) {
            VxRidingProxyEntity selfProxy;
            proxy = selfProxy = (VxRidingProxyEntity)entity;
        } else {
            return;
        }
        VxRidingProxyEntity finalProxy = proxy;
        finalProxy.getPhysicsObjectId().ifPresent(id -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            VxClientObjectDataStore store = manager.getStore();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                return;
            }
            this.velthoric_originalStates.computeIfAbsent(entity.m_19879_(), k -> new VxOriginalState()).setFrom(entity);
            manager.getInterpolator().interpolateFrame(store, index, tickDelta, this.velthoric_interpolatedPosition, this.velthoric_interpolatedRotation);
            Quaternionf physRotation = new Quaternionf(this.velthoric_interpolatedRotation.getX(), this.velthoric_interpolatedRotation.getY(), this.velthoric_interpolatedRotation.getZ(), this.velthoric_interpolatedRotation.getW());
            Vector3f rideOffset = new Vector3f((Vector3fc)finalProxy.getRidePositionOffset());
            physRotation.transform(rideOffset);
            double targetX = this.velthoric_interpolatedPosition.xx() + (double)rideOffset.x;
            double targetY = this.velthoric_interpolatedPosition.yy() + (double)rideOffset.y;
            double targetZ = this.velthoric_interpolatedPosition.zz() + (double)rideOffset.z;
            entity.m_6034_(targetX, targetY, targetZ);
            entity.f_19854_ = targetX;
            entity.f_19855_ = targetY;
            entity.f_19856_ = targetZ;
            entity.f_19790_ = targetX;
            entity.f_19791_ = targetY;
            entity.f_19792_ = targetZ;
        });
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.AFTER)})
    private void velthoric_postRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.forEach((id, state) -> {
            Entity entity = clientWorld.m_6815_(id.intValue());
            if (entity != null) {
                state.applyTo(entity);
            }
        });
        this.velthoric_originalStates.clear();
    }
}

