/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.riding.render.bounds;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.riding.VxRidingProxyEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer_TranformPick {
    @Shadow
    @Final
    private Minecraft f_109059_;

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;")})
    private EntityHitResult velthoric_pickEntityWithOBB(Entity shooter, Vec3 start, Vec3 end, AABB searchBox, Predicate<Entity> filter, double maxDistanceSq, Operation<EntityHitResult> original) {
        Predicate<Entity> vanillaFilter = filter.and(entity -> !(entity.m_20202_() instanceof VxRidingProxyEntity));
        EntityHitResult vanillaResult = (EntityHitResult)original.call(new Object[]{shooter, start, end, searchBox, vanillaFilter, maxDistanceSq});
        double closestHitDistSq = vanillaResult != null ? start.m_82557_(vanillaResult.m_82450_()) : maxDistanceSq;
        EntityHitResult bestOverallResult = vanillaResult;
        List potentialTargets = this.f_109059_.f_91073_.m_6249_(shooter, searchBox, filter);
        float partialTicks = this.f_109059_.m_91296_();
        for (Entity potentialTarget : potentialTargets) {
            double distSq;
            VxRidingProxyEntity proxy;
            Optional physObjectOpt;
            Entity entity2 = potentialTarget.m_20202_();
            if (!(entity2 instanceof VxRidingProxyEntity) || !(physObjectOpt = (proxy = (VxRidingProxyEntity)entity2).getPhysicsObjectId().flatMap(id -> Optional.ofNullable(VxClientObjectManager.getInstance().getObject((UUID)id)))).isPresent() || !((VxClientBody)physObjectOpt.get()).isInitialized()) continue;
            VxClientBody physObject = (VxClientBody)physObjectOpt.get();
            VxTransform physTransform = this.velthoric_getPhysicsObjectTransform(physObject, partialTicks);
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getRidePositionOffset());
            physTransform.getRotation(new Quaternionf()).transform(rideOffset);
            physTransform.getTranslation().addInPlace(rideOffset.x(), rideOffset.y(), rideOffset.z());
            AABB targetAABB = potentialTarget.m_20191_().m_82400_((double)potentialTarget.m_6143_());
            AABB localEntityAABB = targetAABB.m_82386_(-potentialTarget.m_20185_(), -potentialTarget.m_20186_(), -potentialTarget.m_20189_());
            VxOBB obb = new VxOBB(physTransform, localEntityAABB);
            Optional<Vec3> hitPos = obb.clip(start, end);
            if (!hitPos.isPresent() || !((distSq = start.m_82557_(hitPos.get())) < closestHitDistSq)) continue;
            closestHitDistSq = distSq;
            bestOverallResult = new EntityHitResult(potentialTarget, hitPos.get());
        }
        return bestOverallResult;
    }

    @Unique
    private VxTransform velthoric_getPhysicsObjectTransform(VxClientBody clientBody, float partialTicks) {
        VxTransform transform = new VxTransform();
        RVec3 pos = new RVec3();
        Quat rot = new Quat();
        VxClientObjectManager.getInstance().getInterpolator().interpolateFrame(VxClientObjectManager.getInstance().getStore(), clientBody.getDataStoreIndex(), partialTicks, pos, rot);
        transform.getTranslation().set(pos);
        transform.getRotation().set(rot);
        return transform;
    }
}

