/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.riding.render.bounds;

import com.github.stephengold.joltjni.Quat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.UUID;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.xmx.velthoric.physics.object.client.VxClientObjectDataStore;
import net.xmx.velthoric.physics.object.client.VxClientObjectInterpolator;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.riding.VxRidingProxyEntity;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class MixinLivingEntityRenderer_TransformEntity {
    @Unique
    private static final Quat velthoric_interpolatedRotation_ler = new Quat();

    @Inject(method={"setupRotations"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_applyVehicleRotations(LivingEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks, CallbackInfo ci) {
        Entity entity2 = entity.m_20202_();
        if (!(entity2 instanceof VxRidingProxyEntity)) {
            return;
        }
        VxRidingProxyEntity proxy = (VxRidingProxyEntity)entity2;
        proxy.getPhysicsObjectId().ifPresent(id -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            VxClientObjectDataStore store = manager.getStore();
            VxClientObjectInterpolator interpolator = manager.getInterpolator();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                return;
            }
            interpolator.interpolateRotation(store, index, partialTicks, velthoric_interpolatedRotation_ler);
            Quaternionf vehicleRotation = new Quaternionf(velthoric_interpolatedRotation_ler.getX(), velthoric_interpolatedRotation_ler.getY(), velthoric_interpolatedRotation_ler.getZ(), velthoric_interpolatedRotation_ler.getW());
            poseStack.m_252781_(vehicleRotation);
            this.applyDefaultRotations(entity, poseStack, ageInTicks, rotationYaw, partialTicks);
            ci.cancel();
        });
    }

    @Unique
    private void applyDefaultRotations(LivingEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entity.f_20919_ > 0) {
            float f = ((float)entity.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 90.0f));
        } else if (entity.m_21209_()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - entity.m_146909_()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)entity.f_19797_ + partialTicks) * -75.0f));
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
        }
    }
}

