/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.riding.request;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.riding.manager.VxClientRidingManager;
import net.xmx.velthoric.physics.riding.request.C2SRequestRidePacket;
import net.xmx.velthoric.physics.riding.seat.VxSeat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft_RequestRiding {
    @Shadow
    public LocalPlayer f_91074_;
    @Unique
    private final VxRenderState velthoric_renderState = new VxRenderState();
    @Unique
    private final RVec3 velthoric_tempPos = new RVec3();
    @Unique
    private final Quat velthoric_tempRot = new Quat();

    @Inject(method={"handleKeybinds"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_handleRideInteraction(CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91066_.f_92095_.m_90859_() && this.velthoric_performSeatRaycast()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean velthoric_performSeatRaycast() {
        if (this.f_91074_ == null || this.f_91074_.m_20159_()) {
            return false;
        }
        float partialTicks = Minecraft.m_91087_().m_91297_();
        double maxDist = Minecraft.m_91087_().f_91072_.m_105286_();
        Vec3 cameraPos = this.f_91074_.m_20299_(partialTicks);
        Vec3 viewVec = this.f_91074_.m_20252_(partialTicks);
        Vec3 endVec = cameraPos.m_82520_(viewVec.f_82479_ * maxDist, viewVec.f_82480_ * maxDist, viewVec.f_82481_ * maxDist);
        VxClientObjectManager objectManager = VxClientObjectManager.getInstance();
        VxClientRidingManager ridingManager = VxClientRidingManager.getInstance();
        VxClientBody closestBody = null;
        VxSeat closestSeat = null;
        double closestDistSq = Double.MAX_VALUE;
        for (VxClientBody body : objectManager.getAllObjects()) {
            if (!body.isInitialized()) continue;
            body.calculateRenderState(partialTicks, this.velthoric_renderState, this.velthoric_tempPos, this.velthoric_tempRot);
            for (VxSeat seat : ridingManager.getSeats(body.getId())) {
                double distSq;
                VxOBB narrowPhaseBox;
                Optional<Vec3> hitPos;
                AABB broadPhaseBox = seat.getGlobalAABB(this.velthoric_renderState.transform);
                if (!broadPhaseBox.m_82371_(cameraPos, endVec).isPresent() || !(hitPos = (narrowPhaseBox = seat.getGlobalOBB(this.velthoric_renderState.transform)).clip(cameraPos, endVec)).isPresent() || !((distSq = cameraPos.m_82557_(hitPos.get())) < closestDistSq)) continue;
                closestDistSq = distSq;
                closestBody = body;
                closestSeat = seat;
            }
        }
        if (closestBody != null) {
            VxPacketHandler.CHANNEL.sendToServer((Object)new C2SRequestRidePacket(closestBody.getId(), closestSeat.getId()));
            return true;
        }
        return false;
    }
}

