/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.manager.event;

import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.event.api.VxChunkEvent;
import net.xmx.velthoric.event.api.VxLevelEvent;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class ConstraintLifecycleEvents {
    public static void registerEvents() {
        VxChunkEvent.Load.EVENT.register(ConstraintLifecycleEvents::onChunkLoad);
        VxLevelEvent.Save.EVENT.register(ConstraintLifecycleEvents::onLevelSave);
    }

    private static Optional<VxConstraintManager> getConstraintManager(Level level) {
        if (level.m_5776_()) {
            return Optional.empty();
        }
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (world != null && world.getConstraintManager() != null) {
            return Optional.of(world.getConstraintManager());
        }
        return Optional.empty();
    }

    private static void onChunkLoad(VxChunkEvent.Load event) {
        ConstraintLifecycleEvents.getConstraintManager((Level)event.getLevel()).ifPresent(manager -> manager.getConstraintStorage().loadConstraintsInChunk(event.getChunkPos()));
    }

    private static void onLevelSave(VxLevelEvent.Save event) {
        ConstraintLifecycleEvents.getConstraintManager((Level)event.getLevel()).ifPresent(VxConstraintManager::saveData);
    }
}

