/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.constraint.VxConstraint;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.constraint.persistence.VxConstraintCodec;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;
import net.xmx.velthoric.physics.persistence.VxRegionIndex;

public class VxConstraintStorage
extends VxAbstractRegionStorage<UUID, byte[]> {
    private final VxConstraintManager constraintManager;
    private final ConcurrentMap<Long, List<UUID>> chunkToUuidIndex = new ConcurrentHashMap<Long, List<UUID>>();

    public VxConstraintStorage(ServerLevel level, VxConstraintManager constraintManager) {
        super(level, "constraint", "constraint");
        this.constraintManager = constraintManager;
    }

    @Override
    protected VxRegionIndex createRegionIndex() {
        return new VxRegionIndex(this.storagePath, "constraint");
    }

    @Override
    protected void readRegionData(ByteBuf buffer, VxAbstractRegionStorage.RegionData<UUID, byte[]> regionData) {
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buffer);
        while (friendlyBuf.isReadable()) {
            UUID id = friendlyBuf.m_130259_();
            byte[] data = friendlyBuf.m_130052_();
            regionData.entries.put(id, data);
            this.indexConstraintData(id, data);
        }
    }

    @Override
    protected void writeRegionData(ByteBuf buffer, Map<UUID, byte[]> entries) {
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buffer);
        for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
            friendlyBuf.m_130077_(entry.getKey());
            friendlyBuf.m_130087_(entry.getValue());
        }
    }

    public void storeConstraint(VxConstraint constraint) {
        if (constraint == null) {
            return;
        }
        VxBody body1 = this.constraintManager.getObjectManager().getObject(constraint.getBody1Id());
        if (body1 != null) {
            int index = body1.getDataStoreIndex();
            if (index == -1) {
                return;
            }
            ChunkPos chunkPos = this.constraintManager.getObjectManager().getObjectChunkPos(index);
            byte[] data = this.serializeConstraintData(constraint, chunkPos);
            VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.f_45578_ >> 5, chunkPos.f_45579_ >> 5);
            ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
                region.entries.put(constraint.getConstraintId(), data);
                region.dirty.set(true);
                this.regionIndex.put(constraint.getConstraintId(), regionPos);
                this.indexConstraintData(constraint.getConstraintId(), data);
            }, (Executor)this.ioExecutor)).exceptionally(ex -> {
                VxMainClass.LOGGER.error("Failed to store constraint {}", (Object)constraint.getConstraintId(), ex);
                return null;
            });
        }
    }

    public void loadConstraintsInChunk(ChunkPos chunkPos) {
        VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.f_45578_ >> 5, chunkPos.f_45579_ >> 5);
        ((CompletableFuture)this.getRegion(regionPos).thenRunAsync(() -> {
            List idsToLoad = (List)this.chunkToUuidIndex.get(chunkPos.m_45588_());
            if (idsToLoad == null || idsToLoad.isEmpty()) {
                return;
            }
            for (UUID id : List.copyOf(idsToLoad)) {
                if (this.constraintManager.hasActiveConstraint(id) || this.constraintManager.getDataSystem().isPending(id)) continue;
                this.loadConstraint(id);
            }
        }, this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to load constraints in chunk {}", (Object)chunkPos, ex);
            return null;
        });
    }

    public void loadConstraint(UUID id) {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
            if (regionPos == null) {
                return null;
            }
            VxAbstractRegionStorage.RegionData region = this.getRegion(regionPos).join();
            byte[] data = (byte[])region.entries.get(id);
            if (data != null) {
                return this.deserializeConstraint(id, data);
            }
            return null;
        }, this.ioExecutor).thenAcceptAsync(constraint -> {
            if (constraint != null) {
                this.constraintManager.addConstraintFromStorage((VxConstraint)constraint);
            }
        }, (Executor)this.level.m_7654_())).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Exception loading physics constraint {}", (Object)id, ex);
            return null;
        });
    }

    public void removeData(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return;
        }
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            byte[] data = (byte[])region.entries.remove(id);
            if (data != null) {
                region.dirty.set(true);
                this.deIndexConstraint(id, data);
                this.regionIndex.remove(id);
            }
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to remove data for constraint {}", (Object)id, ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VxConstraint deserializeConstraint(UUID id, byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            buf.readLong();
            VxConstraint vxConstraint = VxConstraintCodec.deserialize(id, buf);
            return vxConstraint;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeConstraintData(VxConstraint constraint, ChunkPos pos) {
        ByteBuf buffer = Unpooled.buffer();
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        try {
            buf.writeLong(pos.m_45588_());
            VxConstraintCodec.serialize(constraint, buf);
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (buffer.refCnt() > 0) {
                buffer.release();
            }
        }
    }

    private void indexConstraintData(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        this.chunkToUuidIndex.computeIfAbsent(chunkKey, k -> new CopyOnWriteArrayList()).add(id);
    }

    private void deIndexConstraint(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        List idList = (List)this.chunkToUuidIndex.get(chunkKey);
        if (idList != null) {
            idList.remove(id);
            if (idList.isEmpty()) {
                this.chunkToUuidIndex.remove(chunkKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getChunkKeyFromData(byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            long l = buf.readLong();
            return l;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }
}

