/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.client;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.xmx.velthoric.physics.object.AbstractDataStore;
import org.jetbrains.annotations.Nullable;

public class VxClientObjectDataStore
extends AbstractDataStore {
    private static final int INITIAL_CAPACITY = 256;
    private final Map<UUID, Integer> uuidToIndex = new HashMap<UUID, Integer>();
    private final List<UUID> indexToUuid = new ArrayList<UUID>();
    private final Deque<Integer> freeIndices = new ArrayDeque<Integer>();
    private int count = 0;
    private int capacity = 0;
    public long[] state0_timestamp;
    public float[] state0_posX;
    public float[] state0_posY;
    public float[] state0_posZ;
    public float[] state0_rotX;
    public float[] state0_rotY;
    public float[] state0_rotZ;
    public float[] state0_rotW;
    public float[] state0_velX;
    public float[] state0_velY;
    public float[] state0_velZ;
    public boolean[] state0_isActive;
    public float[] @Nullable [] state0_vertexData;
    public long[] state1_timestamp;
    public float[] state1_posX;
    public float[] state1_posY;
    public float[] state1_posZ;
    public float[] state1_rotX;
    public float[] state1_rotY;
    public float[] state1_rotZ;
    public float[] state1_rotW;
    public float[] state1_velX;
    public float[] state1_velY;
    public float[] state1_velZ;
    public boolean[] state1_isActive;
    public float[] @Nullable [] state1_vertexData;
    public float[] prev_posX;
    public float[] prev_posY;
    public float[] prev_posZ;
    public float[] prev_rotX;
    public float[] prev_rotY;
    public float[] prev_rotZ;
    public float[] prev_rotW;
    public float[] @Nullable [] prev_vertexData;
    public float[] render_posX;
    public float[] render_posY;
    public float[] render_posZ;
    public float[] render_rotX;
    public float[] render_rotY;
    public float[] render_rotZ;
    public float[] render_rotW;
    public float[] @Nullable [] render_vertexData;
    public boolean[] render_isInitialized;
    public EBodyType[] objectType;
    public ByteBuffer[] customData;
    public RVec3[] lastKnownPosition;

    public VxClientObjectDataStore() {
        this.allocate(256);
    }

    private void allocate(int newCapacity) {
        this.state0_timestamp = this.grow(this.state0_timestamp, newCapacity);
        this.state0_posX = this.grow(this.state0_posX, newCapacity);
        this.state0_posY = this.grow(this.state0_posY, newCapacity);
        this.state0_posZ = this.grow(this.state0_posZ, newCapacity);
        this.state0_rotX = this.grow(this.state0_rotX, newCapacity);
        this.state0_rotY = this.grow(this.state0_rotY, newCapacity);
        this.state0_rotZ = this.grow(this.state0_rotZ, newCapacity);
        this.state0_rotW = this.grow(this.state0_rotW, newCapacity);
        this.state0_velX = this.grow(this.state0_velX, newCapacity);
        this.state0_velY = this.grow(this.state0_velY, newCapacity);
        this.state0_velZ = this.grow(this.state0_velZ, newCapacity);
        this.state0_isActive = this.grow(this.state0_isActive, newCapacity);
        this.state0_vertexData = this.grow(this.state0_vertexData, newCapacity);
        this.state1_timestamp = this.grow(this.state1_timestamp, newCapacity);
        this.state1_posX = this.grow(this.state1_posX, newCapacity);
        this.state1_posY = this.grow(this.state1_posY, newCapacity);
        this.state1_posZ = this.grow(this.state1_posZ, newCapacity);
        this.state1_rotX = this.grow(this.state1_rotX, newCapacity);
        this.state1_rotY = this.grow(this.state1_rotY, newCapacity);
        this.state1_rotZ = this.grow(this.state1_rotZ, newCapacity);
        this.state1_rotW = this.grow(this.state1_rotW, newCapacity);
        this.state1_velX = this.grow(this.state1_velX, newCapacity);
        this.state1_velY = this.grow(this.state1_velY, newCapacity);
        this.state1_velZ = this.grow(this.state1_velZ, newCapacity);
        this.state1_isActive = this.grow(this.state1_isActive, newCapacity);
        this.state1_vertexData = this.grow(this.state1_vertexData, newCapacity);
        this.prev_posX = this.grow(this.prev_posX, newCapacity);
        this.prev_posY = this.grow(this.prev_posY, newCapacity);
        this.prev_posZ = this.grow(this.prev_posZ, newCapacity);
        this.prev_rotX = this.grow(this.prev_rotX, newCapacity);
        this.prev_rotY = this.grow(this.prev_rotY, newCapacity);
        this.prev_rotZ = this.grow(this.prev_rotZ, newCapacity);
        this.prev_rotW = this.grow(this.prev_rotW, newCapacity);
        this.prev_vertexData = this.grow(this.prev_vertexData, newCapacity);
        this.render_posX = this.grow(this.render_posX, newCapacity);
        this.render_posY = this.grow(this.render_posY, newCapacity);
        this.render_posZ = this.grow(this.render_posZ, newCapacity);
        this.render_rotX = this.grow(this.render_rotX, newCapacity);
        this.render_rotY = this.grow(this.render_rotY, newCapacity);
        this.render_rotZ = this.grow(this.render_rotZ, newCapacity);
        this.render_rotW = this.grow(this.render_rotW, newCapacity);
        this.render_vertexData = this.grow(this.render_vertexData, newCapacity);
        this.render_isInitialized = this.grow(this.render_isInitialized, newCapacity);
        this.objectType = this.grow(this.objectType, newCapacity);
        this.customData = this.grow(this.customData, newCapacity);
        this.lastKnownPosition = this.grow(this.lastKnownPosition, newCapacity);
        this.capacity = newCapacity;
    }

    public int addObject(UUID id) {
        int n;
        if (this.count == this.capacity) {
            this.allocate(this.capacity * 2);
        }
        if (this.freeIndices.isEmpty()) {
            int n2 = this.count;
            n = n2;
            this.count = n2 + 1;
        } else {
            n = this.freeIndices.pop();
        }
        int index = n;
        this.uuidToIndex.put(id, index);
        if (index >= this.indexToUuid.size()) {
            this.indexToUuid.add(id);
        } else {
            this.indexToUuid.set(index, id);
        }
        return index;
    }

    public void removeObject(UUID id) {
        Integer index = this.uuidToIndex.remove(id);
        if (index != null) {
            this.resetIndex(index);
            this.freeIndices.push(index);
            this.indexToUuid.set(index, null);
        }
    }

    public void clear() {
        this.uuidToIndex.clear();
        this.indexToUuid.clear();
        this.freeIndices.clear();
        this.count = 0;
        this.allocate(256);
    }

    @Nullable
    public Integer getIndexForId(UUID id) {
        return this.uuidToIndex.get(id);
    }

    public int getObjectCount() {
        return this.count;
    }

    public Collection<UUID> getAllObjectIds() {
        return Collections.unmodifiableSet(this.uuidToIndex.keySet());
    }

    public boolean hasObject(UUID id) {
        return this.uuidToIndex.containsKey(id);
    }

    private void resetIndex(int index) {
        this.state0_timestamp[index] = 0L;
        this.state1_timestamp[index] = 0L;
        this.render_isInitialized[index] = false;
        this.state0_isActive[index] = false;
        this.state1_isActive[index] = false;
        this.state0_vertexData[index] = null;
        this.state1_vertexData[index] = null;
        this.prev_vertexData[index] = null;
        this.render_vertexData[index] = null;
        this.customData[index] = null;
        this.objectType[index] = null;
        if (this.lastKnownPosition != null && this.lastKnownPosition[index] != null) {
            this.lastKnownPosition[index].loadZero();
        }
        this.state0_velZ[index] = 0.0f;
        this.state0_velY[index] = 0.0f;
        this.state0_velX[index] = 0.0f;
        this.state1_velZ[index] = 0.0f;
        this.state1_velY[index] = 0.0f;
        this.state1_velX[index] = 0.0f;
    }
}

