/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.client.renderer;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.event.api.VxRenderEvent;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.mixin.impl.debug.EntityRenderDispatcherAccessor;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.object.client.body.VxClientSoftBody;
import net.xmx.velthoric.physics.object.client.renderer.VxDebugRenderer;
import org.joml.Matrix4f;

public class VxPhysicsRenderer {
    private static final float CULLING_BOUNDS_INFLATION = 2.0f;
    private static final VxRenderState finalRenderState = new VxRenderState();
    private static final RVec3 interpolatedPosition = new RVec3();
    private static final Quat interpolatedRotation = new Quat();
    private static final VxDebugRenderer debugRenderer = new VxDebugRenderer();

    public static void registerEvents() {
        VxRenderEvent.ClientRenderLevelStageEvent.EVENT.register(VxPhysicsRenderer::onRenderLevelStage);
    }

    private static void onRenderLevelStage(VxRenderEvent.ClientRenderLevelStageEvent event) {
        if (event.getStage() != VxRenderEvent.ClientRenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.m_91288_() == null) {
            return;
        }
        VxClientObjectManager manager = VxClientObjectManager.getInstance();
        if (manager.getAllObjects().isEmpty()) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        PoseStack poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        Frustum frustum = new Frustum(poseStack.m_85850_().m_252922_(), projectionMatrix);
        frustum.m_113002_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        for (VxClientBody body : manager.getAllObjects()) {
            try {
                int packedLight;
                AABB objectAABB;
                if (!body.isInitialized() || !frustum.m_113029_(objectAABB = body.getCullingAABB(2.0f))) continue;
                body.calculateRenderState(partialTicks, finalRenderState, interpolatedPosition, interpolatedRotation);
                if (body instanceof VxClientSoftBody && VxPhysicsRenderer.finalRenderState.vertexData != null && VxPhysicsRenderer.finalRenderState.vertexData.length >= 3) {
                    packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)BlockPos.m_274561_((double)VxPhysicsRenderer.finalRenderState.vertexData[0], (double)VxPhysicsRenderer.finalRenderState.vertexData[1], (double)VxPhysicsRenderer.finalRenderState.vertexData[2]));
                } else {
                    RVec3 renderPosition = VxPhysicsRenderer.finalRenderState.transform.getTranslation();
                    packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)BlockPos.m_274561_((double)renderPosition.xx(), (double)renderPosition.yy(), (double)renderPosition.zz()));
                }
                body.render(poseStack, bufferSource, partialTicks, packedLight, finalRenderState);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Error rendering physics object {}", (Object)body.getId(), (Object)e);
            }
        }
        if (((EntityRenderDispatcherAccessor)mc.m_91290_()).getRenderHitBoxes()) {
            debugRenderer.render(poseStack, (MultiBufferSource)bufferSource, manager, partialTicks);
        }
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }
}

