/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.manager.event;

import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.event.api.VxChunkEvent;
import net.xmx.velthoric.event.api.VxLevelEvent;
import net.xmx.velthoric.physics.object.manager.VxObjectManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class ObjectLifecycleEvents {
    public static void registerEvents() {
        VxChunkEvent.Load.EVENT.register(ObjectLifecycleEvents::onChunkLoad);
        VxChunkEvent.Unload.EVENT.register(ObjectLifecycleEvents::onChunkUnload);
        VxLevelEvent.Save.EVENT.register(ObjectLifecycleEvents::onLevelSave);
    }

    private static Optional<VxObjectManager> getObjectManager(Level level) {
        if (level.m_5776_()) {
            return Optional.empty();
        }
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        return world != null ? Optional.ofNullable(world.getObjectManager()) : Optional.empty();
    }

    private static void onChunkLoad(VxChunkEvent.Load event) {
        ObjectLifecycleEvents.getObjectManager((Level)event.getLevel()).ifPresent(manager -> manager.getObjectStorage().loadObjectsInChunk(event.getChunkPos()));
    }

    private static void onChunkUnload(VxChunkEvent.Unload event) {
        ObjectLifecycleEvents.getObjectManager((Level)event.getLevel()).ifPresent(manager -> manager.onChunkUnload(event.getChunkPos()));
    }

    private static void onLevelSave(VxLevelEvent.Save event) {
        ObjectLifecycleEvents.getObjectManager((Level)event.getLevel()).ifPresent(VxObjectManager::saveAll);
    }
}

