/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.packet;

import com.github.stephengold.joltjni.enumerate.EBodyType;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.object.type.VxSoftBody;
import net.xmx.velthoric.physics.riding.VxRideable;
import net.xmx.velthoric.physics.riding.manager.VxRidingManager;
import net.xmx.velthoric.physics.riding.seat.VxSeat;

public class VxSpawnData {
    public final UUID id;
    public final ResourceLocation typeIdentifier;
    public final EBodyType objectType;
    public final long timestamp;
    public final byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VxSpawnData(VxBody obj, long timestamp) {
        this.id = obj.getPhysicsId();
        this.typeIdentifier = obj.getType().getTypeId();
        this.objectType = obj instanceof VxSoftBody ? EBodyType.SoftBody : EBodyType.RigidBody;
        this.timestamp = timestamp;
        VxByteBuf buf = new VxByteBuf(Unpooled.buffer());
        try {
            obj.getTransform().toBuffer(buf);
            obj.writeInitialSyncData(buf);
            if (obj instanceof VxRideable) {
                VxRidingManager ridingManager = obj.getWorld().getRidingManager();
                Collection<VxSeat> seats = ridingManager.getSeats(obj.getPhysicsId());
                buf.m_130130_(seats.size());
                for (VxSeat seat : seats) {
                    seat.encode(buf);
                }
            } else {
                buf.m_130130_(0);
            }
            this.data = new byte[buf.readableBytes()];
            buf.readBytes(this.data);
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    public VxSpawnData(FriendlyByteBuf buf) {
        this.id = buf.m_130259_();
        this.typeIdentifier = buf.m_130281_();
        this.objectType = (EBodyType)buf.m_130066_(EBodyType.class);
        this.timestamp = buf.readLong();
        this.data = buf.m_130052_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        buf.m_130085_(this.typeIdentifier);
        buf.m_130068_((Enum)this.objectType);
        buf.writeLong(this.timestamp);
        buf.m_130087_(this.data);
    }

    public int estimateSize() {
        String typeStr = this.typeIdentifier.toString();
        return 16 + FriendlyByteBuf.m_130053_((int)typeStr.length()) + typeStr.length() + 4 + 8 + FriendlyByteBuf.m_130053_((int)this.data.length) + this.data.length;
    }
}

