/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.zip.DataFormatException;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;

public class S2CRemoveBodyBatchPacket {
    private final List<UUID> ids;

    public S2CRemoveBodyBatchPacket(List<UUID> ids) {
        this.ids = ids;
    }

    public S2CRemoveBodyBatchPacket(FriendlyByteBuf buf) {
        byte[] compressedData = buf.m_130052_();
        try {
            byte[] decompressedData = VxPacketUtils.decompress(compressedData);
            FriendlyByteBuf decompressedBuf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.m_130242_();
            this.ids = new ObjectArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.ids.add(decompressedBuf.m_130259_());
            }
        }
        catch (IOException | DataFormatException e) {
            throw new IllegalStateException("Failed to decompress remove body batch packet", e);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        FriendlyByteBuf tempBuf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            tempBuf.m_130130_(this.ids.size());
            for (UUID id : this.ids) {
                tempBuf.m_130077_(id);
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.m_130087_(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress remove body batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static void handle(S2CRemoveBodyBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            for (UUID id : msg.ids) {
                manager.removeObject(id);
            }
        });
    }
}

