/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.packet.batch;

import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.physics.object.client.VxClientObjectDataStore;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import org.jetbrains.annotations.Nullable;

public class S2CUpdateVerticesBatchPacket {
    private final int count;
    private final UUID[] ids;
    private final float[][] vertexData;

    public S2CUpdateVerticesBatchPacket(int count, UUID[] ids, float[] @Nullable [] vertexData) {
        this.count = count;
        this.ids = ids;
        this.vertexData = vertexData;
    }

    public S2CUpdateVerticesBatchPacket(FriendlyByteBuf buf) {
        this.count = buf.m_130242_();
        this.ids = new UUID[this.count];
        this.vertexData = new float[this.count][];
        for (int i = 0; i < this.count; ++i) {
            this.ids[i] = buf.m_130259_();
            if (buf.readBoolean()) {
                int length = buf.m_130242_();
                this.vertexData[i] = new float[length];
                for (int j = 0; j < length; ++j) {
                    this.vertexData[i][j] = buf.readFloat();
                }
                continue;
            }
            this.vertexData[i] = null;
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.count);
        for (int i = 0; i < this.count; ++i) {
            buf.m_130077_(this.ids[i]);
            float[] vertices = this.vertexData[i];
            if (vertices != null && vertices.length > 0) {
                buf.writeBoolean(true);
                buf.m_130130_(vertices.length);
                for (float v : vertices) {
                    buf.writeFloat(v);
                }
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static void handle(S2CUpdateVerticesBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            VxClientObjectDataStore store = manager.getStore();
            for (int i = 0; i < msg.count; ++i) {
                Integer index = store.getIndexForId(msg.ids[i]);
                if (index == null) continue;
                store.state1_vertexData[index.intValue()] = msg.vertexData[i];
            }
        });
    }
}

