/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.object.registry;

import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxObjectRegistry {
    private static volatile VxObjectRegistry instance;
    private final Map<ResourceLocation, VxObjectType<?>> registeredTypes = new ConcurrentHashMap();
    private final Map<ResourceLocation, ClientFactory> clientFactories = new ConcurrentHashMap<ResourceLocation, ClientFactory>();

    private VxObjectRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VxObjectRegistry getInstance() {
        if (instance != null) return instance;
        Class<VxObjectRegistry> clazz = VxObjectRegistry.class;
        synchronized (VxObjectRegistry.class) {
            if (instance != null) return instance;
            instance = new VxObjectRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(VxObjectType<?> type) {
        if (this.registeredTypes.containsKey(type.getTypeId())) {
            VxMainClass.LOGGER.warn("VxObjectType '{}' is already registered. Overwriting.", (Object)type.getTypeId());
        }
        this.registeredTypes.put(type.getTypeId(), type);
    }

    @Nullable
    public VxBody create(ResourceLocation typeId, VxPhysicsWorld world, UUID id) {
        VxObjectType<?> type = this.registeredTypes.get(typeId);
        if (type == null) {
            VxMainClass.LOGGER.error("No VxObjectType registered for ID: {}", (Object)typeId);
            return null;
        }
        try {
            return type.create(world, id);
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to create physics object of type {}", (Object)typeId, (Object)e);
            return null;
        }
    }

    @Nullable
    public VxObjectType<?> getRegistrationData(ResourceLocation typeId) {
        return this.registeredTypes.get(typeId);
    }

    public Map<ResourceLocation, VxObjectType<?>> getRegisteredTypes() {
        return Map.copyOf(this.registeredTypes);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientFactory(ResourceLocation typeId, ClientFactory factory) {
        this.clientFactories.put(typeId, factory);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public VxClientBody createClientBody(ResourceLocation typeId, UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        ClientFactory factory = this.clientFactories.get(typeId);
        if (factory != null) {
            try {
                return factory.create(id, manager, dataStoreIndex, objectType);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Failed to create client body of type {}", (Object)typeId, (Object)e);
            }
        } else {
            VxMainClass.LOGGER.error("No client factory registered for VxObjectType ID: {}", (Object)typeId);
        }
        return null;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface ClientFactory {
        public VxClientBody create(UUID var1, VxClientObjectManager var2, int var3, EBodyType var4);
    }
}

