/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.persistence.VxPersistenceManager;
import net.xmx.velthoric.physics.persistence.VxRegionIndex;

public abstract class VxAbstractRegionStorage<K, V> {
    protected final ExecutorService ioExecutor;
    protected final Path storagePath;
    private final String filePrefix;
    protected final ConcurrentHashMap<RegionPos, RegionData<K, V>> loadedRegions = new ConcurrentHashMap();
    protected final ServerLevel level;
    protected VxRegionIndex regionIndex;

    public VxAbstractRegionStorage(ServerLevel level, String storageSubFolder, String filePrefix) {
        this.level = level;
        this.filePrefix = filePrefix;
        this.ioExecutor = VxPersistenceManager.getExecutor();
        Path worldRoot = level.m_7654_().m_129843_(LevelResource.f_78182_);
        Path dimensionRoot = DimensionType.m_196975_((ResourceKey)level.m_46472_(), (Path)worldRoot);
        this.storagePath = dimensionRoot.resolve("velthoric").resolve(storageSubFolder);
    }

    protected abstract VxRegionIndex createRegionIndex();

    public void initialize() {
        this.regionIndex = this.createRegionIndex();
        try {
            Files.createDirectories(this.storagePath, new FileAttribute[0]);
            if (this.regionIndex != null) {
                this.regionIndex.load();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create region storage directory: " + String.valueOf(this.storagePath), e);
        }
    }

    public void shutdown() {
        CompletableFuture<Void> saveFuture = this.saveDirtyRegions();
        try {
            saveFuture.get(15L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Error or timeout waiting for dirty regions to save during shutdown for {}", (Object)this.filePrefix, (Object)e);
        }
        if (this.regionIndex != null) {
            this.regionIndex.save();
        }
        this.loadedRegions.clear();
    }

    public CompletableFuture<Void> saveDirtyRegions() {
        ArrayList saveFutures = new ArrayList();
        this.loadedRegions.forEach((pos, data) -> {
            if (data.dirty.get() && data.saving.compareAndSet(false, true)) {
                CompletionStage saveTask = CompletableFuture.runAsync(() -> {
                    try {
                        if (data.dirty.compareAndSet(true, false)) {
                            this.saveRegionToFile((RegionPos)pos, (RegionData<K, V>)data);
                        }
                    }
                    finally {
                        data.saving.set(false);
                    }
                }, this.ioExecutor).exceptionally(ex -> {
                    data.saving.set(false);
                    VxMainClass.LOGGER.error("Exception in save task for region {}-{}", (Object)this.filePrefix, pos, ex);
                    return null;
                });
                saveFutures.add(saveTask);
            }
        });
        if (this.regionIndex != null) {
            this.regionIndex.save();
        }
        return CompletableFuture.allOf(saveFutures.toArray(new CompletableFuture[0]));
    }

    protected CompletableFuture<RegionData<K, V>> getRegion(RegionPos pos) {
        RegionData<K, V> existingData = this.loadedRegions.get(pos);
        if (existingData != null) {
            return CompletableFuture.completedFuture(existingData);
        }
        return CompletableFuture.supplyAsync(() -> this.loadedRegions.computeIfAbsent(pos, p -> this.loadRegionFromFile((RegionPos)p)), this.ioExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionData<K, V> loadRegionFromFile(RegionPos pos) {
        RegionData regionData;
        block7: {
            Path regionFile = this.getRegionFile(pos);
            regionData = new RegionData();
            if (!Files.exists(regionFile, new LinkOption[0])) {
                return regionData;
            }
            try {
                byte[] fileBytes = Files.readAllBytes(regionFile);
                if (fileBytes.length <= 0) break block7;
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])fileBytes);
                try {
                    this.readRegionData(byteBuf, regionData);
                }
                finally {
                    if (byteBuf.refCnt() > 0) {
                        byteBuf.release();
                    }
                }
            }
            catch (IOException e) {
                VxMainClass.LOGGER.error("Failed to load region file {}", (Object)regionFile, (Object)e);
            }
        }
        return regionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRegionToFile(RegionPos pos, RegionData<K, V> data) {
        block15: {
            Path regionFile = this.getRegionFile(pos);
            if (data.entries.isEmpty()) {
                try {
                    Files.deleteIfExists(regionFile);
                }
                catch (IOException e) {
                    VxMainClass.LOGGER.error("Failed to delete empty region file {}", (Object)regionFile, (Object)e);
                }
                return;
            }
            ByteBuf buffer = Unpooled.buffer();
            try {
                this.writeRegionData(buffer, data.entries);
                if (buffer.readableBytes() <= 0) break block15;
                Files.createDirectories(regionFile.getParent(), new FileAttribute[0]);
                try (FileChannel channel = FileChannel.open(regionFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    channel.write(buffer.nioBuffer());
                }
            }
            catch (IOException e) {
                VxMainClass.LOGGER.error("Failed to save region file {}", (Object)regionFile, (Object)e);
                data.dirty.set(true);
            }
            finally {
                if (buffer.refCnt() > 0) {
                    buffer.release();
                }
            }
        }
    }

    private Path getRegionFile(RegionPos pos) {
        return this.storagePath.resolve(String.format("%s.%d.%d.vxdat", this.filePrefix, pos.x(), pos.z()));
    }

    protected abstract void readRegionData(ByteBuf var1, RegionData<K, V> var2);

    protected abstract void writeRegionData(ByteBuf var1, Map<K, V> var2);

    public static class RegionData<K, V> {
        public final ConcurrentHashMap<K, V> entries = new ConcurrentHashMap();
        public final AtomicBoolean dirty = new AtomicBoolean(false);
        public final AtomicBoolean saving = new AtomicBoolean(false);
    }

    public record RegionPos(int x, int z) {
    }
}

