/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.raycasting;

import com.github.stephengold.joltjni.BodyLockRead;
import com.github.stephengold.joltjni.ClosestHitCastRayCollector;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RRayCast;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.RayCastResult;
import com.github.stephengold.joltjni.RayCastSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstNarrowPhaseQuery;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class VxRaytracing {
    private VxRaytracing() {
    }

    public static Optional<VxHitResult> raycast(Level level, VxClipContext context) {
        net.minecraft.world.phys.Vec3 from = context.m_45702_();
        net.minecraft.world.phys.Vec3 to = context.m_45693_();
        ArrayList hits = new ArrayList();
        VxRaytracing.raycastMinecraftInternal(level, context).ifPresent(hits::add);
        if (context.isIncludePhysics()) {
            double maxDistance = from.m_82554_(to);
            net.minecraft.world.phys.Vec3 direction = to.m_82546_(from).m_82541_();
            RVec3 rayOrigin = new RVec3((float)from.f_82479_, (float)from.f_82480_, (float)from.f_82481_);
            Vec3 rayDirection = new Vec3((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_);
            VxRaytracing.raycastPhysicsInternal(level, rayOrigin, rayDirection, (float)maxDistance).ifPresent(hits::add);
        }
        return hits.stream().min(Comparator.comparingDouble(hit -> hit.m_82450_().m_82557_(from)));
    }

    public static Optional<VxHitResult> raycastMinecraft(Level level, VxClipContext context) {
        return VxRaytracing.raycastMinecraftInternal(level, context);
    }

    public static Optional<VxHitResult> raycastPhysics(Level level, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        return VxRaytracing.raycastPhysicsInternal(level, rayOrigin, rayDirection, maxDistance);
    }

    private static Optional<VxHitResult> raycastMinecraftInternal(Level level, VxClipContext context) {
        double entityHitSq;
        Predicate<Entity> entityPredicate;
        AABB searchBox;
        EntityHitResult entityHitResult;
        net.minecraft.world.phys.Vec3 from = context.m_45702_();
        net.minecraft.world.phys.Vec3 to = context.m_45693_();
        BlockHitResult blockHitResult = level.m_45547_((ClipContext)context);
        double closestHitSq = blockHitResult.m_6662_() == HitResult.Type.MISS ? Double.MAX_VALUE : blockHitResult.m_82450_().m_82557_(from);
        BlockHitResult finalHit = blockHitResult;
        Entity entity = context.getEntity();
        if (entity != null && (entityHitResult = ProjectileUtil.m_37304_((Level)level, (Entity)entity, (net.minecraft.world.phys.Vec3)from, (net.minecraft.world.phys.Vec3)to, (AABB)(searchBox = new AABB(from, to)), entityPredicate = e -> !e.m_5833_() && e.m_6087_())) != null && (entityHitSq = entityHitResult.m_82450_().m_82557_(from)) < closestHitSq) {
            finalHit = entityHitResult;
        }
        return finalHit.m_6662_() != HitResult.Type.MISS ? Optional.of(new VxHitResult((HitResult)finalHit)) : Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<VxHitResult> raycastPhysicsInternal(Level level, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (physicsWorld == null) return Optional.empty();
        if (!physicsWorld.isRunning()) return Optional.empty();
        if (physicsWorld.getPhysicsSystem() == null) {
            return Optional.empty();
        }
        PhysicsSystem physicsSystem = physicsWorld.getPhysicsSystem();
        ConstNarrowPhaseQuery narrowPhaseQuery = physicsSystem.getNarrowPhaseQuery();
        Vec3 directionAndLength = Op.star((Vec3Arg)rayDirection, maxDistance);
        try (RRayCast ray = new RRayCast(rayOrigin, directionAndLength);
             RayCastSettings settings = new RayCastSettings();
             ClosestHitCastRayCollector collector = new ClosestHitCastRayCollector();){
            narrowPhaseQuery.castRay(ray, settings, collector);
            if (!collector.hadHit()) return Optional.empty();
            RayCastResult hit = collector.getHit();
            float hitFraction = hit.getFraction();
            RVec3 hitPointR = ray.getPointOnRay(hitFraction);
            net.minecraft.world.phys.Vec3 hitPoint = new net.minecraft.world.phys.Vec3(hitPointR.xx(), hitPointR.yy(), hitPointR.zz());
            int bodyId = hit.getBodyId();
            try (BodyLockRead lock = new BodyLockRead(physicsSystem.getBodyLockInterface(), bodyId);){
                if (!lock.succeededAndIsInBroadPhase()) return Optional.empty();
                Vec3 hitNormal = lock.getBody().getWorldSpaceSurfaceNormal(hit.getSubShapeId2(), hitPointR);
                Optional<VxHitResult> optional = Optional.of(new VxHitResult(hitPoint, bodyId, new Vec3(hitNormal), hitFraction));
                return optional;
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Exception during physics raycast", (Throwable)e);
        }
        return Optional.empty();
    }

    private static net.minecraft.world.phys.Vec3 transformToLocal(net.minecraft.world.phys.Vec3 worldVec, Vector3f pos, Quaternionf invRot) {
        Vector3f tempVec = new Vector3f((float)worldVec.f_82479_, (float)worldVec.f_82480_, (float)worldVec.f_82481_);
        tempVec.sub((Vector3fc)pos);
        invRot.transform(tempVec);
        return new net.minecraft.world.phys.Vec3((double)tempVec.x, (double)tempVec.y, (double)tempVec.z);
    }

    private static Vec3 calculateHitNormal(net.minecraft.world.phys.Vec3 localHit, AABB localAABB, Quaternionf worldRot) {
        float epsilon = 1.0E-5f;
        Vector3f localNormal = new Vector3f();
        if (Math.abs(localHit.f_82479_ - localAABB.f_82288_) < (double)1.0E-5f) {
            localNormal.x = -1.0f;
        } else if (Math.abs(localHit.f_82479_ - localAABB.f_82291_) < (double)1.0E-5f) {
            localNormal.x = 1.0f;
        } else if (Math.abs(localHit.f_82480_ - localAABB.f_82289_) < (double)1.0E-5f) {
            localNormal.y = -1.0f;
        } else if (Math.abs(localHit.f_82480_ - localAABB.f_82292_) < (double)1.0E-5f) {
            localNormal.y = 1.0f;
        } else if (Math.abs(localHit.f_82481_ - localAABB.f_82290_) < (double)1.0E-5f) {
            localNormal.z = -1.0f;
        } else if (Math.abs(localHit.f_82481_ - localAABB.f_82293_) < (double)1.0E-5f) {
            localNormal.z = 1.0f;
        }
        worldRot.transform(localNormal);
        return new Vec3(localNormal.x, localNormal.y, localNormal.z);
    }
}

