/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.riding.input;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.riding.input.VxRideInput;
import net.xmx.velthoric.physics.riding.manager.VxRidingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class C2SRideInputPacket {
    private final VxRideInput input;

    public C2SRideInputPacket(VxRideInput input) {
        this.input = input;
    }

    public C2SRideInputPacket(FriendlyByteBuf buf) {
        this.input = new VxRideInput(buf);
    }

    public void encode(FriendlyByteBuf buf) {
        this.input.encode(buf);
    }

    public static void handle(C2SRideInputPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.m_284548_().m_46472_());
            if (physicsWorld != null) {
                VxRidingManager ridingManager = physicsWorld.getRidingManager();
                ridingManager.handlePlayerInput(player, msg.input);
            }
        });
    }
}

