/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.riding.manager;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.init.registry.EntityRegistry;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.object.type.VxBody;
import net.xmx.velthoric.physics.riding.VxRideable;
import net.xmx.velthoric.physics.riding.VxRidingProxyEntity;
import net.xmx.velthoric.physics.riding.input.VxRideInput;
import net.xmx.velthoric.physics.riding.seat.VxSeat;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxRidingManager {
    private final VxPhysicsWorld world;
    private final Object2ObjectMap<UUID, Map<UUID, VxSeat>> objectToSeatsMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, UUID> playerToObjectIdMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, Map<UUID, ServerPlayer>> objectToRidersMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, VxSeat> playerToSeatMap = new Object2ObjectOpenHashMap();

    public VxRidingManager(VxPhysicsWorld world) {
        this.world = world;
    }

    public void addSeat(UUID objectId, VxSeat seat) {
        ((Map)this.objectToSeatsMap.computeIfAbsent((Object)objectId, k -> new ConcurrentHashMap())).put(seat.getId(), seat);
    }

    public void removeSeat(UUID objectId, UUID seatId) {
        Map seats = (Map)this.objectToSeatsMap.get((Object)objectId);
        if (seats != null) {
            seats.remove(seatId);
            if (seats.isEmpty()) {
                this.objectToSeatsMap.remove((Object)objectId);
            }
        }
    }

    public void requestRiding(ServerPlayer player, UUID objectId, UUID seatId) {
        VxBody body = this.world.getObjectManager().getObject(objectId);
        if (!(body instanceof VxRideable)) {
            VxMainClass.LOGGER.warn("Player {} requested to ride non-rideable object {}", (Object)player.m_7755_().getString(), (Object)objectId);
            return;
        }
        VxRideable rideable = (VxRideable)((Object)body);
        Optional<VxSeat> seatOpt = this.getSeat(objectId, seatId);
        if (seatOpt.isEmpty()) {
            VxMainClass.LOGGER.warn("Player {} requested to ride non-existent seat '{}' on object {}", (Object)player.m_7755_().getString(), (Object)seatId, (Object)objectId);
            return;
        }
        VxSeat seat = seatOpt.get();
        double reachDistance = player.m_7500_() ? 5.0 : 4.5;
        double distanceSq = player.m_146892_().m_82531_((double)body.getTransform().getTranslation().x(), (double)body.getTransform().getTranslation().y(), (double)body.getTransform().getTranslation().z());
        if (distanceSq > reachDistance * reachDistance) {
            VxMainClass.LOGGER.warn("Player {} is too far to ride object {} (distSq: {}, reach: {})", (Object)player.m_7755_().getString(), (Object)objectId, (Object)distanceSq, (Object)reachDistance);
            return;
        }
        this.startRiding(player, rideable, seat);
    }

    public Optional<VxSeat> getSeat(UUID objectId, UUID seatId) {
        Map seats = (Map)this.objectToSeatsMap.get((Object)objectId);
        return seats != null ? Optional.ofNullable((VxSeat)seats.get(seatId)) : Optional.empty();
    }

    public Optional<VxSeat> getSeatForPlayer(ServerPlayer player) {
        return Optional.ofNullable((VxSeat)this.playerToSeatMap.get((Object)player.m_20148_()));
    }

    public Optional<VxRideable> getRideableForPlayer(ServerPlayer player) {
        UUID objectId = (UUID)this.playerToObjectIdMap.get((Object)player.m_20148_());
        if (objectId == null) {
            return Optional.empty();
        }
        VxBody body = this.world.getObjectManager().getObject(objectId);
        if (body instanceof VxRideable) {
            return Optional.of((VxRideable)((Object)body));
        }
        return Optional.empty();
    }

    public Collection<VxSeat> getSeats(UUID objectId) {
        Map seats = (Map)this.objectToSeatsMap.get((Object)objectId);
        return seats != null ? seats.values() : Collections.emptyList();
    }

    public void startRiding(ServerPlayer player, VxRideable rideable, VxSeat seat) {
        if (player.m_9236_().m_5776_() || this.isRiding(player) || this.isSeatOccupied(rideable.getPhysicsId(), seat)) {
            return;
        }
        VxRidingProxyEntity proxy = new VxRidingProxyEntity((EntityType)EntityRegistry.RIDING_PROXY.get(), player.m_9236_());
        Vector3f rideOffsetJoml = new Vector3f((Vector3fc)seat.getRiderOffset());
        proxy.setFollowInfo(rideable.getPhysicsId(), rideOffsetJoml);
        VxTransform initialTransform = rideable.getTransform();
        RVec3 initialPos = initialTransform.getTranslation();
        Quat initialRot = initialTransform.getRotation();
        Quaternionf initialQuat = new Quaternionf(initialRot.getX(), initialRot.getY(), initialRot.getZ(), initialRot.getW());
        Vector3f worldOffset = new Vector3f((Vector3fc)rideOffsetJoml);
        initialQuat.transform(worldOffset);
        double finalX = initialPos.x() + worldOffset.x();
        double finalY = initialPos.y() + worldOffset.y();
        double finalZ = initialPos.z() + worldOffset.z();
        Vector3f eulerAngles = new Vector3f();
        initialQuat.getEulerAnglesXYZ(eulerAngles);
        proxy.m_6034_(finalX, finalY, finalZ);
        proxy.m_146922_((float)Math.toDegrees(eulerAngles.y));
        this.world.getLevel().m_7967_((Entity)proxy);
        player.m_7998_((Entity)proxy, true);
        ((Map)this.objectToRidersMap.computeIfAbsent((Object)rideable.getPhysicsId(), k -> Maps.newHashMap())).put(player.m_20148_(), player);
        this.playerToObjectIdMap.put((Object)player.m_20148_(), (Object)rideable.getPhysicsId());
        this.playerToSeatMap.put((Object)player.m_20148_(), (Object)seat);
        rideable.onStartRiding(player, seat);
    }

    public void stopRiding(ServerPlayer player) {
        Entity vehicle;
        if (!this.isRiding(player)) {
            return;
        }
        UUID playerUuid = player.m_20148_();
        UUID objectId = (UUID)this.playerToObjectIdMap.remove((Object)playerUuid);
        this.playerToSeatMap.remove((Object)playerUuid);
        if (objectId != null) {
            this.getRideableForPlayer(player).ifPresent(rideable -> rideable.onStopRiding(player));
            Map riders = (Map)this.objectToRidersMap.get((Object)objectId);
            if (riders != null) {
                riders.remove(playerUuid);
                if (riders.isEmpty()) {
                    this.objectToRidersMap.remove((Object)objectId);
                }
            }
        }
        if ((vehicle = player.m_20202_()) instanceof VxRidingProxyEntity) {
            player.m_8127_();
            vehicle.m_146870_();
        }
    }

    public void onGameTick() {
        ArrayList<Object> playersToStopRiding = new ArrayList<Object>();
        HashSet objectIds = Sets.newHashSet((Iterable)this.objectToRidersMap.keySet());
        for (UUID uUID : objectIds) {
            Map riders = (Map)this.objectToRidersMap.get((Object)uUID);
            if (riders == null) continue;
            VxBody physObject = this.world.getObjectManager().getObject(uUID);
            if (physObject == null) {
                playersToStopRiding.addAll(riders.values());
                continue;
            }
            VxTransform trans = physObject.getTransform();
            RVec3 pos = trans.getTranslation();
            Quat rot = trans.getRotation();
            Quaternionf jomlQuat = new Quaternionf(rot.getX(), rot.getY(), rot.getZ(), rot.getW());
            Vector3f eulerAngles = new Vector3f();
            jomlQuat.getEulerAnglesXYZ(eulerAngles);
            float yawDegrees = (float)Math.toDegrees(eulerAngles.y);
            for (ServerPlayer rider : Sets.newHashSet(riders.values())) {
                if (rider.m_213877_() || !rider.m_20159_() || !(rider.m_20202_() instanceof VxRidingProxyEntity)) {
                    playersToStopRiding.add(rider);
                    continue;
                }
                VxSeat seat = (VxSeat)this.playerToSeatMap.get((Object)rider.m_20148_());
                if (seat != null) {
                    Entity vehicle = rider.m_20202_();
                    Vector3f rideOffset = new Vector3f((Vector3fc)seat.getRiderOffset());
                    jomlQuat.transform(rideOffset);
                    double finalX = pos.x() + rideOffset.x();
                    double finalY = pos.y() + rideOffset.y();
                    double finalZ = pos.z() + rideOffset.z();
                    vehicle.m_6034_(finalX, finalY, finalZ);
                    vehicle.m_146922_(yawDegrees);
                    continue;
                }
                playersToStopRiding.add(rider);
            }
        }
        for (ServerPlayer serverPlayer : playersToStopRiding) {
            this.stopRiding(serverPlayer);
        }
    }

    public void handlePlayerInput(ServerPlayer player, VxRideInput input) {
        if (!this.isRiding(player)) {
            return;
        }
        this.getSeatForPlayer(player).ifPresent(seat -> {
            if (seat.isDriverSeat()) {
                this.getRideableForPlayer(player).ifPresent(rideable -> rideable.handleDriverInput(player, input));
            }
        });
    }

    public void onPlayerDisconnect(ServerPlayer player) {
        if (this.isRiding(player)) {
            this.stopRiding(player);
        }
    }

    public Map<UUID, Map<UUID, VxSeat>> getAllSeatsByObject() {
        return Collections.unmodifiableMap(this.objectToSeatsMap);
    }

    public boolean isRiding(ServerPlayer player) {
        return this.playerToObjectIdMap.containsKey((Object)player.m_20148_());
    }

    public boolean isSeatOccupied(UUID objectId, VxSeat seat) {
        Map riders = (Map)this.objectToRidersMap.get((Object)objectId);
        if (riders == null || riders.isEmpty()) {
            return false;
        }
        for (UUID riderUuid : riders.keySet()) {
            VxSeat occupiedSeat = (VxSeat)this.playerToSeatMap.get((Object)riderUuid);
            if (occupiedSeat == null || !occupiedSeat.getId().equals(seat.getId())) continue;
            return true;
        }
        return false;
    }
}

